/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtil {
    public static <K, T> Set<T> findOrCreateSet(Map<K, Set<T>> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        Set result = M.get(key);
        if (result == null) {
            result = HashSetFactory.make(2);
            M.put(key, result);
        }
        return result;
    }

    public static <K, K2, V> Map<K2, V> findOrCreateMap(Map<K, Map<K2, V>> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        Map result = M.get(key);
        if (result == null) {
            result = HashMapFactory.make(2);
            M.put(key, result);
        }
        return result;
    }

    public static <K, V> WeakHashMap<K, V> findOrCreateWeakHashMap(Map<Object, WeakHashMap<K, V>> M, Object key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        WeakHashMap<K, V> result = M.get(key);
        if (result == null) {
            result = new WeakHashMap(2);
            M.put(key, result);
        }
        return result;
    }

    public static <K, V> Map<V, Set<K>> inverseMap(Map<K, Set<V>> m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        Map result = HashMapFactory.make(m.size());
        for (Map.Entry<K, Set<V>> E : m.entrySet()) {
            K key = E.getKey();
            Set<V> values = E.getValue();
            for (V v : values) {
                Set s = MapUtil.findOrCreateSet(result, v);
                s.add(key);
            }
        }
        return result;
    }

    public static <K, V> Map<Set<K>, V> groupKeysByValue(Map<K, V> m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        Map result = HashMapFactory.make();
        Map valueToKeys = HashMapFactory.make();
        for (Map.Entry<K, V> E : m.entrySet()) {
            K key = E.getKey();
            V value = E.getValue();
            MapUtil.findOrCreateSet(valueToKeys, value).add(key);
        }
        for (Map.Entry<K, V> E : valueToKeys.entrySet()) {
            K value = E.getKey();
            Set keys = (Set)E.getValue();
            result.put(keys, value);
        }
        return result;
    }
}

