/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonNullSingletonIterator<T>
implements Iterator<T> {
    private T it;

    public NonNullSingletonIterator(T o) {
        Assertions._assert(o != null);
        this.it = o;
    }

    @Override
    public boolean hasNext() {
        return this.it != null;
    }

    @Override
    public T next() {
        if (this.it == null) {
            throw new NoSuchElementException();
        }
        T result = this.it;
        this.it = null;
        return result;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static <T> NonNullSingletonIterator<T> make(T item) {
        return new NonNullSingletonIterator<T>(item);
    }
}

