/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayMapping<T>
implements OrdinalSetMapping<T> {
    private final T[] array;
    private final HashMap<T, Integer> map = HashMapFactory.make();

    public ObjectArrayMapping(T[] array) {
        this.array = array;
        int i = 0;
        while (i < array.length) {
            this.map.put(array[i], new Integer(i));
            ++i;
        }
    }

    @Override
    public T getMappedObject(int n) throws NoSuchElementException {
        if (n >= this.array.length) {
            throw new NoSuchElementException("n too big: " + n);
        }
        return this.array[n];
    }

    @Override
    public int getMappedIndex(Object o) {
        if (this.map.get(o) == null) {
            return -1;
        }
        return this.map.get(o);
    }

    @Override
    public boolean hasMappedIndex(Object o) {
        return this.map.get(o) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int add(Object o) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public int getMaximumIndex() {
        return this.array.length - 1;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }
}

