/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.annotations.Internal;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class ParanoidHashSet<T>
extends HashSet<T> {
    public static final long serialVersionUID = 30919839181133333L;
    private final Map<Integer, Set<T>> hcFreq;
    private int nAdded = 0;
    private final int BAD_HC = 3;

    public ParanoidHashSet(Collection<T> s) throws NullPointerException {
        super(s.size());
        this.hcFreq = HashMapFactory.make(s.size());
        Iterator<T> it = s.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public ParanoidHashSet() {
        this.hcFreq = HashMapFactory.make();
    }

    public ParanoidHashSet(int size) {
        super(size);
        this.hcFreq = HashMapFactory.make(size);
    }

    @Override
    public boolean add(T arg0) {
        boolean result;
        if (arg0 == null) {
            throw new IllegalArgumentException("arg0 is null");
        }
        if (arg0.hashCode() == System.identityHashCode(arg0)) {
            Assertions._assert(false, arg0.getClass().toString());
        }
        if (result = super.add(arg0)) {
            ++this.nAdded;
            int hc = arg0.hashCode();
            Set<T> s = this.hcFreq.get(new Integer(hc));
            if (s == null) {
                HashSet<T> h = new HashSet<T>(1);
                h.add(arg0);
                this.hcFreq.put(new Integer(hc), h);
            } else if (s.size() == 3) {
                for (T o : s) {
                    System.err.println(o + " " + o.hashCode());
                }
                Assertions._assert(false, "bad hc " + arg0.getClass() + " " + arg0);
            } else {
                s.add(arg0);
            }
        }
        return result;
    }
}

