/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallMap<K, V>
implements Map<K, V> {
    private static final boolean DEBUG_USAGE = false;
    private static final int DEBUG_MAX_SIZE = 20;
    private Object[] keysAndValues;

    @Override
    public int size() {
        if (this.keysAndValues == null) {
            return 0;
        }
        return this.keysAndValues.length / 2;
    }

    public K getKey(int i) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getKey on empty map");
        }
        return (K)this.keysAndValues[i];
    }

    public Object getValue(int i) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getValue on empty map");
        }
        return this.keysAndValues[this.size() + i];
    }

    @Override
    public boolean isEmpty() {
        return this.keysAndValues == null;
    }

    @Override
    public boolean containsKey(Object key) {
        int i = 0;
        while (i < this.size()) {
            if (this.keysAndValues[i].equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.keysAndValues == null) {
            return false;
        }
        int i = this.size();
        while (i < this.keysAndValues.length) {
            if (this.keysAndValues[i].equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key != null) {
            int i = 0;
            while (i < this.size()) {
                if (this.keysAndValues[i] != null && this.keysAndValues[i].equals(key)) {
                    return (V)this.keysAndValues[this.size() + i];
                }
                ++i;
            }
        }
        return null;
    }

    private void growByOne() {
        Object[] old = this.keysAndValues;
        int length = old == null ? 0 : old.length;
        this.keysAndValues = new Object[length + 2];
        int i = 0;
        while (i < length / 2) {
            this.keysAndValues[i] = old[i];
            ++i;
        }
        i = 0;
        while (i < length / 2) {
            this.keysAndValues[i + 1 + length / 2] = old[length / 2 + i];
            ++i;
        }
    }

    @Override
    public V put(Object key, Object value) {
        Assertions._assert(key != null);
        int i = 0;
        while (i < this.size()) {
            if (this.keysAndValues[i] != null && this.keysAndValues[i].equals(key)) {
                Object result = this.keysAndValues[this.size() + i];
                this.keysAndValues[this.size() + i] = value;
                return (V)result;
            }
            ++i;
        }
        this.growByOne();
        this.keysAndValues[this.size() - 1] = key;
        this.keysAndValues[this.keysAndValues.length - 1] = value;
        return null;
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.keysAndValues = null;
    }

    @Override
    public Set<K> keySet() {
        HashSet result = HashSetFactory.make(this.size());
        int i = 0;
        while (i < this.size()) {
            result.add(this.keysAndValues[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        int s = this.size();
        if (s == 0) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make(s);
        int i = s;
        while (i < this.keysAndValues.length) {
            result.add(this.keysAndValues[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() throws UnimplementedError {
        Assertions.UNREACHABLE("must implement entrySet");
        return null;
    }
}

