/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.config;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.FileProvider;
import com.ibm.wala.util.debug.Assertions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class AnalysisScopeReader {
    private static final ClassLoader MY_CLASSLOADER = AnalysisScopeReader.class.getClassLoader();
    private static final String BASIC_FILE = "primordial.txt";

    public static AnalysisScope read(String scopeFileName, File exclusionsFile, ClassLoader javaLoader) {
        AnalysisScope scope = AnalysisScope.createAnalysisScope(Collections.singleton(Language.JAVA));
        return AnalysisScopeReader.read(scope, scopeFileName, exclusionsFile, javaLoader);
    }

    public static AnalysisScope read(AnalysisScope scope, String scopeFileName, File exclusionsFile, ClassLoader javaLoader) {
        try {
            String line;
            File scopeFile = FileProvider.getFile(scopeFileName, javaLoader);
            assert (scopeFile.exists());
            BufferedReader r = new BufferedReader(new FileReader(scopeFile));
            while ((line = r.readLine()) != null) {
                StringTokenizer toks = new StringTokenizer(line, "\n,");
                Atom loaderName = Atom.findOrCreateUnicodeAtom(toks.nextToken());
                Atom languageName = Atom.findOrCreateUnicodeAtom(toks.nextToken());
                ClassLoaderReference walaLoader = new ClassLoaderReference(loaderName, languageName);
                String entryType = toks.nextToken();
                String entryPathname = toks.nextToken();
                if ("classFile".equals(entryType)) {
                    File cf = FileProvider.getFile(entryPathname, javaLoader);
                    scope.addClassFileToScope(walaLoader, cf);
                    continue;
                }
                if ("sourceFile".equals(entryType)) {
                    File sf = FileProvider.getFile(entryPathname, javaLoader);
                    scope.addSourceFileToScope(walaLoader, sf, entryPathname);
                    continue;
                }
                if ("binaryDir".equals(entryType)) {
                    File bd = FileProvider.getFile(entryPathname, javaLoader);
                    assert (bd.isDirectory());
                    scope.addToScope(walaLoader, new BinaryDirectoryTreeModule(bd));
                    continue;
                }
                if ("sourceDir".equals(entryType)) {
                    File sd = FileProvider.getFile(entryPathname, javaLoader);
                    assert (sd.isDirectory());
                    scope.addToScope(walaLoader, new SourceDirectoryTreeModule(sd));
                    continue;
                }
                if ("jarFile".equals(entryType)) {
                    Module M = FileProvider.getJarFileModule(entryPathname, javaLoader);
                    scope.addToScope(walaLoader, M);
                    continue;
                }
                if ("loaderImpl".equals(entryType)) {
                    scope.setLoaderImpl(walaLoader, entryPathname);
                    continue;
                }
                if ("stdlib".equals(entryType)) {
                    String[] stdlibs = WalaProperties.getJ2SEJarFiles();
                    int i = 0;
                    while (i < stdlibs.length) {
                        scope.addToScope(walaLoader, new JarFile(stdlibs[i]));
                        ++i;
                    }
                    continue;
                }
                Assertions.UNREACHABLE();
            }
            if (exclusionsFile != null) {
                scope.setExclusions(new FileOfClasses(exclusionsFile));
            }
        }
        catch (IOException e) {
            Assertions.UNREACHABLE(e.toString());
        }
        return scope;
    }

    public static AnalysisScope makePrimordialScope(File exclusionsFile) {
        return AnalysisScopeReader.read(BASIC_FILE, exclusionsFile, MY_CLASSLOADER);
    }

    public static AnalysisScope makeJavaBinaryAnalysisScope(String classPath, File exclusionsFile) {
        AnalysisScope scope = AnalysisScopeReader.makePrimordialScope(exclusionsFile);
        ClassLoaderReference loader = scope.getLoader(AnalysisScope.APPLICATION);
        try {
            StringTokenizer paths = new StringTokenizer(classPath, File.pathSeparator);
            while (paths.hasMoreTokens()) {
                String path = paths.nextToken();
                if (path.endsWith(".jar")) {
                    scope.addToScope(loader, new JarFile(path));
                    continue;
                }
                File f = new File(path);
                if (f.isDirectory()) {
                    scope.addToScope(loader, new BinaryDirectoryTreeModule(f));
                    continue;
                }
                scope.addClassFileToScope(loader, f);
            }
        }
        catch (IOException e) {
            Assertions.UNREACHABLE(e.toString());
        }
        return scope;
    }
}

