/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.config;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.NestedJarFileModule;
import com.ibm.wala.core.plugin.CorePlugin;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class FileProvider {
    private static final int DEBUG_LEVEL = 0;

    public static IWorkspace getWorkspace() {
        try {
            return ResourcesPlugin.getWorkspace();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Module getJarFileModule(String fileName) throws IOException {
        return FileProvider.getJarFileModule(fileName, FileProvider.class.getClassLoader());
    }

    public static Module getJarFileModule(String fileName, ClassLoader loader) throws IOException {
        if (CorePlugin.getDefault() == null) {
            return FileProvider.getJarFileFromClassLoader(fileName, loader);
        }
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile((IPath)new Path(fileName));
            if (file != null) {
                return new JarFileModule(new JarFile(fileName, false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FileProvider.getFromPlugin(CorePlugin.getDefault(), fileName);
    }

    public static URL getResource(String fileName) throws IOException {
        return FileProvider.getResource(fileName, FileProvider.class.getClassLoader());
    }

    public static URL getResource(String fileName, ClassLoader loader) throws IOException {
        return CorePlugin.getDefault() == null ? loader.getResource(fileName) : FileLocator.find((Bundle)CorePlugin.getDefault().getBundle(), (IPath)new Path(fileName), null);
    }

    public static File getFile(String fileName) throws IOException {
        return FileProvider.getFile(fileName, FileProvider.class.getClassLoader());
    }

    public static File getFile(String fileName, ClassLoader loader) throws IOException {
        return CorePlugin.getDefault() == null ? FileProvider.getFileFromClassLoader(fileName, loader) : FileProvider.getFileFromPlugin(CorePlugin.getDefault(), fileName);
    }

    public static File getFileFromPlugin(Plugin p, String fileName) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        URL url = FileProvider.getFileURLFromPlugin(p, fileName);
        if (url == null) {
            throw new FileNotFoundException(fileName);
        }
        return new File(FileProvider.filePathFromURL(url));
    }

    private static JarFileModule getFromPlugin(Plugin p, String fileName) throws IOException {
        URL url = FileProvider.getFileURLFromPlugin(p, fileName);
        return url == null ? null : new JarFileModule(new JarFile(FileProvider.filePathFromURL(url)));
    }

    private static URL getFileURLFromPlugin(Plugin p, String fileName) throws IOException {
        URL url = FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(fileName), null);
        if (url == null) {
            String libFileName = "lib/" + fileName;
            url = FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(libFileName), null);
            if (url == null) {
                String binFileName = "bin/" + fileName;
                url = FileLocator.find((Bundle)p.getBundle(), (IPath)new Path(binFileName), null);
                if (url == null) {
                    return null;
                }
            }
        }
        url = FileLocator.toFileURL((URL)url);
        url = FileProvider.fixupFileURLSpaces(url);
        return url;
    }

    private static URL fixupFileURLSpaces(URL url) {
        String urlString = url.toExternalForm();
        StringBuffer fixedUpUrl = new StringBuffer();
        int lastIndex = 0;
        while (true) {
            int spaceIndex;
            if ((spaceIndex = urlString.indexOf(32, lastIndex)) < 0) break;
            fixedUpUrl.append(urlString.substring(lastIndex, spaceIndex));
            fixedUpUrl.append("%20");
            lastIndex = spaceIndex + 1;
        }
        fixedUpUrl.append(urlString.substring(lastIndex));
        try {
            return new URL(fixedUpUrl.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public static File getFileFromClassLoader(String fileName, ClassLoader loader) throws FileNotFoundException {
        URL url = loader.getResource(fileName);
        if (url == null) {
            File f = new File(fileName);
            if (f.exists()) {
                return f;
            }
            throw new FileNotFoundException(fileName);
        }
        return new File(FileProvider.filePathFromURL(url));
    }

    public static Module getJarFileFromClassLoader(String fileName, ClassLoader loader) throws IOException {
        URL url = loader.getResource(fileName);
        if (url == null) {
            return new JarFileModule(new JarFile(fileName, false));
        }
        if (url.getProtocol().equals("jar")) {
            JarURLConnection jc = (JarURLConnection)url.openConnection();
            JarFile f = jc.getJarFile();
            JarEntry entry = jc.getJarEntry();
            JarFileModule parent = new JarFileModule(f);
            return new NestedJarFileModule(parent, entry);
        }
        String filePath = FileProvider.filePathFromURL(url);
        return new JarFileModule(new JarFile(filePath, false));
    }

    public static String filePathFromURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        URI uri = null;
        try {
            uri = new URI(url.toString());
        }
        catch (URISyntaxException e) {
            Assertions.UNREACHABLE();
        }
        String filePath = uri.getPath();
        return filePath;
    }
}

