/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.debug;

import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;

public class Trace {
    private static final String TRACEFILE_KEY = "com.ibm.wala.tracefile";
    private static String traceFile = null;
    private static PrintStream out = null;

    public static synchronized void setTraceFile(String fileName) {
        System.setProperty(TRACEFILE_KEY, fileName);
    }

    public static PrintStream getTraceStream() {
        Trace.setTraceFile();
        return out;
    }

    private static synchronized boolean setTraceFile() {
        String fileName = System.getProperty(TRACEFILE_KEY);
        if (fileName == null) {
            if (traceFile != null) {
                traceFile = null;
                if (out != null) {
                    out.close();
                }
                out = null;
            }
            return false;
        }
        if (traceFile != null) {
            if (traceFile.equals(fileName)) {
                return true;
            }
            traceFile = null;
            if (out != null) {
                out.close();
            }
            out = null;
        }
        traceFile = fileName;
        File f = new File(fileName);
        try {
            out = new PrintStream(new FileOutputStream(f));
            return true;
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: file not found: " + fileName);
            Assertions.UNREACHABLE("Invalid trace file: " + f);
            return false;
        }
    }

    public static synchronized void println(String string) {
        if (Trace.setTraceFile()) {
            out.println(string);
        }
    }

    public static synchronized void println(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        Trace.println(o.toString());
    }

    public static synchronized void print(String string) {
        if (Trace.setTraceFile()) {
            out.print(string);
        }
    }

    public static synchronized void format(String format, Object ... args) {
        if (Trace.setTraceFile()) {
            out.format(format, args);
        }
    }

    public static void flush() {
        if (Trace.setTraceFile()) {
            out.flush();
        }
    }

    public static PrintWriter getTraceWriter() {
        if (Trace.setTraceFile()) {
            return new PrintWriter(out);
        }
        return null;
    }

    public static boolean guardedPrintln(String S, String substring) throws IllegalArgumentException {
        if (S == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (substring == null || S.indexOf(substring) > -1) {
            Trace.println(S);
            return true;
        }
        return false;
    }

    public static boolean guardedPrint(String S, String substring) throws IllegalArgumentException {
        if (S == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (substring == null || S.indexOf(substring) > -1) {
            Trace.print(S);
            return true;
        }
        return false;
    }

    public static void printCollection(String string, Collection c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        Trace.println(string);
        if (c.isEmpty()) {
            Trace.println("none\n");
        } else {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Trace.println(it.next().toString());
            }
            Trace.println("\n");
        }
    }

    public static synchronized String getTraceFile() {
        Trace.setTraceFile();
        return traceFile;
    }
}

