/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberedGraph<T>
extends AbstractGraph<T>
implements NumberedGraph<T> {
    @Override
    public int getMaxNumber() {
        return ((NumberedNodeManager)this.getNodeManager()).getMaxNumber();
    }

    @Override
    public T getNode(int number) {
        return ((NumberedNodeManager)this.getNodeManager()).getNode(number);
    }

    @Override
    public int getNumber(T N) {
        if (N == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        return ((NumberedNodeManager)this.getNodeManager()).getNumber(N);
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, this);
    }

    @Override
    public IntSet getPredNodeNumbers(T node) throws IllegalArgumentException {
        assert (this.getEdgeManager() != null);
        return ((NumberedEdgeManager)this.getEdgeManager()).getPredNodeNumbers(node);
    }

    @Override
    public IntSet getSuccNodeNumbers(T node) throws IllegalArgumentException {
        return ((NumberedEdgeManager)this.getEdgeManager()).getSuccNodeNumbers(node);
    }
}

