/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.Path;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acyclic {
    public static <T> boolean isAcyclic(NumberedGraph<T> G, T root) {
        IBinaryNaturalRelation r = Acyclic.computeBackEdges(G, root);
        Iterator it = r.iterator();
        return !it.hasNext();
    }

    public static <T> IBinaryNaturalRelation computeBackEdges(NumberedGraph<T> G, T root) {
        BasicNaturalRelation result = new BasicNaturalRelation();
        Set visited = HashSetFactory.make();
        Set onstack = HashSetFactory.make();
        Acyclic.dfs(result, root, G, visited, onstack);
        return result;
    }

    private static <T> void dfs(BasicNaturalRelation result, T root, NumberedGraph<T> G, Set<T> visited, Set<T> onstack) {
        visited.add(root);
        onstack.add(root);
        Iterator<T> it = G.getSuccNodes(root);
        while (it.hasNext()) {
            T dstNode = it.next();
            if (onstack.contains(dstNode)) {
                int src = G.getNumber(root);
                int dst = G.getNumber(dstNode);
                result.add(src, dst);
            }
            if (visited.contains(dstNode)) continue;
            Acyclic.dfs(result, dstNode, G, visited, onstack);
        }
        onstack.remove(root);
    }

    public static <T> boolean hasIncomingBackEdges(Path p, NumberedGraph<T> G, T root) {
        IBinaryNaturalRelation backedges = Acyclic.computeBackEdges(G, root);
        int index = 0;
        while (index < p.size()) {
            int gn = p.get(index);
            Iterator predIter = G.getPredNodes(G.getNode(gn));
            while (predIter.hasNext()) {
                if (!backedges.contains(G.getNumber(predIter.next()), gn)) continue;
                return true;
            }
            ++index;
        }
        return false;
    }

    public static <T> Collection<Path> computeAcyclicPaths(NumberedGraph<T> G, T root, T src, T sink, int max) {
        Collection result = HashSetFactory.make();
        SubGraph acyclic = new SubGraph(G, Acyclic.computeBackEdges(G, root));
        Collection worklist = HashSetFactory.make();
        Path sinkPath = Path.make(G.getNumber(sink));
        worklist.add(sinkPath);
        while (!worklist.isEmpty() && result.size() <= max) {
            Path p = (Path)worklist.iterator().next();
            worklist.remove(p);
            int first = p.get(0);
            if (first == G.getNumber(src)) {
                result.add(p);
                continue;
            }
            IntIterator it = acyclic.getPredNodeNumbers(acyclic.getNode(first)).intIterator();
            while (it.hasNext()) {
                worklist.add(Path.prepend(it.next(), p));
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubGraph<T>
    extends AbstractNumberedGraph<T> {
        private final NumberedGraph<T> delegate;
        private final IBinaryNaturalRelation ignoreEdges;
        private final Edges edges;

        SubGraph(NumberedGraph<T> delegate, IBinaryNaturalRelation ignoreEdges) {
            this.delegate = delegate;
            this.ignoreEdges = ignoreEdges;
            this.edges = new Edges();
        }

        @Override
        protected EdgeManager<T> getEdgeManager() {
            return this.edges;
        }

        @Override
        protected NodeManager<T> getNodeManager() {
            return this.delegate;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class Edges
        implements NumberedEdgeManager<T> {
            private Edges() {
            }

            @Override
            public void addEdge(T src, T dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public int getPredNodeCount(T N) {
                Assertions.UNREACHABLE();
                return 0;
            }

            @Override
            public Iterator<? extends T> getPredNodes(T N) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public int getSuccNodeCount(T N) {
                Assertions.UNREACHABLE();
                return 0;
            }

            @Override
            public Iterator<? extends T> getSuccNodes(T N) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public boolean hasEdge(T src, T dst) {
                Assertions.UNREACHABLE();
                return false;
            }

            @Override
            public void removeAllIncidentEdges(T node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(T src, T dst) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(T node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(T node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public IntSet getPredNodeNumbers(T node) {
                IntSet s = SubGraph.this.delegate.getPredNodeNumbers(node);
                MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                IntIterator it = s.intIterator();
                while (it.hasNext()) {
                    int y = it.next();
                    if (SubGraph.this.ignoreEdges.contains(y, SubGraph.this.getNumber(node))) continue;
                    result.add(y);
                }
                return result;
            }

            @Override
            public IntSet getSuccNodeNumbers(T node) {
                Assertions.UNREACHABLE();
                return null;
            }
        }
    }
}

