/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.BFSIterator;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIntegrity {
    static final int DEBUG_LEVEL = 0;

    public static <T> void check(Graph<T> G) throws UnsoundGraphException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        GraphIntegrity.checkNodeCount(G);
        GraphIntegrity.checkEdges(G);
        GraphIntegrity.checkEdgeCounts(G);
    }

    private static <T> void checkEdgeCounts(Graph<T> G) throws UnsoundGraphException {
        for (Object N : G) {
            int count1 = G.getSuccNodeCount(N);
            int count2 = 0;
            Iterator it2 = G.getSuccNodes(N);
            while (it2.hasNext()) {
                it2.next();
                ++count2;
            }
            if (count1 != count2) {
                throw new UnsoundGraphException("getSuccNodeCount " + count1 + " is wrong for node " + N);
            }
            int count3 = G.getPredNodeCount(N);
            int count4 = 0;
            Iterator it22 = G.getPredNodes(N);
            while (it22.hasNext()) {
                it22.next();
                ++count4;
            }
            if (count3 == count4) continue;
            throw new UnsoundGraphException("getPredNodeCount " + count1 + " is wrong for node " + N);
        }
    }

    private static <T> void checkEdges(Graph<T> G) throws UnsoundGraphException {
        for (Object N : G) {
            if (!G.containsNode(N)) {
                throw new UnsoundGraphException(N + " is not contained in the the graph " + G.containsNode(N));
            }
            Iterator p = G.getPredNodes(N);
            block1: while (p.hasNext()) {
                Object pred = p.next();
                if (!G.containsNode(pred)) {
                    throw new UnsoundGraphException(pred + " is a predecessor of " + N + " but is not contained in the graph");
                }
                Iterator s = G.getSuccNodes(pred);
                while (s.hasNext()) {
                    Object succ = s.next();
                    if (succ.equals(N)) continue block1;
                }
                G.getPredNodes(N);
                G.getSuccNodes(pred);
                throw new UnsoundGraphException(pred + " is a predecessor of " + N + " but inverse doesn't hold");
            }
            Iterator s = G.getSuccNodes(N);
            block3: while (s.hasNext()) {
                Object succ = s.next();
                if (!G.containsNode(succ)) {
                    throw new UnsoundGraphException(succ + " is a successor of " + N + " but is not contained in the graph");
                }
                Iterator p2 = G.getPredNodes(succ);
                while (p2.hasNext()) {
                    Object pred = p2.next();
                    if (pred.equals(N)) continue block3;
                }
                throw new UnsoundGraphException(succ + " is a successor of " + N + " but inverse doesn't hold");
            }
        }
    }

    private static <T> void checkNodeCount(Graph<T> G) throws UnsoundGraphException {
        int n1 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            n1 = G.getNumberOfNodes();
            n2 = 0;
            for (Object n : G) {
                ++n2;
            }
            n3 = 0;
            Iterator it = new BFSIterator<T>(G);
            while (it.hasNext()) {
                it.next();
                ++n3;
            }
            n4 = 0;
            it = DFS.iterateDiscoverTime(G);
            while (it.hasNext()) {
                it.next();
                ++n4;
            }
            n5 = 0;
            it = DFS.iterateFinishTime(G);
            while (it.hasNext()) {
                it.next();
                ++n5;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new UnsoundGraphException(e.toString());
        }
        if (n1 != n2) {
            throw new UnsoundGraphException("n1: " + n1 + " n2: " + n2);
        }
        if (n1 != n3) {
            throw GraphIntegrity.setDiffException("n1: " + n1 + " n3: " + n3, G.iterator(), new BFSIterator<T>(G));
        }
        if (n1 != n4) {
            throw new UnsoundGraphException("n1: " + n1 + " n4: " + n3);
        }
        if (n1 != n5) {
            throw new UnsoundGraphException("n1: " + n1 + " n5: " + n3);
        }
    }

    private static <T> UnsoundGraphException setDiffException(String msg, Iterator<? extends T> i1, Iterator<T> i2) {
        HashSet set1 = HashSetFactory.make();
        while (i1.hasNext()) {
            T o1 = i1.next();
            boolean b = set1.add(o1);
            if (b) continue;
            return new UnsoundGraphException("set1 already contained " + o1);
        }
        HashSet set2 = HashSetFactory.make();
        while (i2.hasNext()) {
            T o2 = i2.next();
            boolean b = set2.add(o2);
            if (b) continue;
            return new UnsoundGraphException("set2 already contained " + o2);
        }
        Trace.printCollection("set 1 ", set1);
        Trace.printCollection("set 2 ", set2);
        HashSet s1clone = (HashSet)set1.clone();
        set1.removeAll(set2);
        if (set1.size() > 0) {
            Object first = set1.iterator().next();
            msg = String.valueOf(msg) + ", first iterator contained " + first;
            return new UnsoundGraphException(msg);
        }
        set2.removeAll(s1clone);
        if (set2.size() > 0) {
            Object first = set2.iterator().next();
            msg = String.valueOf(msg) + ", 2nd iterator contained " + first;
            return new UnsoundGraphException(msg);
        }
        msg = String.valueOf(msg) + "set2.size = 0";
        return new UnsoundGraphException(msg);
    }

    public static class UnsoundGraphException
    extends Exception {
        private static final long serialVersionUID = 1503478788521696930L;

        public UnsoundGraphException() {
        }

        public UnsoundGraphException(String s) {
            super(s);
        }
    }
}

