/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.warnings.WalaException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSlicer {
    public static <T> Set<T> slice(Graph<T> g, Filter<T> f) throws WalaException {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        HashSet roots = HashSetFactory.make();
        for (Object o : g) {
            if (!f.accepts(o)) continue;
            roots.add(o);
        }
        Set<T> result = DFS.getReachableNodes(GraphInverter.invert(g), roots);
        return result;
    }

    public static <T> Graph<T> prune(final Graph<T> g, final Filter<T> f) {
        final NodeManager n = new NodeManager<T>(){
            int nodeCount = -1;

            @Override
            public Iterator<T> iterator() {
                return new FilterIterator(g.iterator(), f);
            }

            @Override
            public int getNumberOfNodes() {
                if (this.nodeCount == -1) {
                    this.nodeCount = IteratorUtil.count(this.iterator());
                }
                return this.nodeCount;
            }

            @Override
            public void addNode(T n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(T n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean containsNode(T N) {
                return f.accepts(N) && g.containsNode(N);
            }
        };
        final EdgeManager e = new EdgeManager<T>(){

            @Override
            public Iterator<T> getPredNodes(T N) {
                return new FilterIterator(g.getPredNodes(N), f);
            }

            @Override
            public int getPredNodeCount(T N) {
                return IteratorUtil.count(this.getPredNodes(N));
            }

            @Override
            public Iterator<T> getSuccNodes(T N) {
                return new FilterIterator(g.getSuccNodes(N), f);
            }

            @Override
            public int getSuccNodeCount(T N) {
                return IteratorUtil.count(this.getSuccNodes(N));
            }

            @Override
            public void addEdge(T src, T dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(T src, T dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeAllIncidentEdges(T node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(T node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(T node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean hasEdge(T src, T dst) {
                return g.hasEdge(src, dst) && f.accepts(src) && f.accepts(dst);
            }
        };
        AbstractGraph output = new AbstractGraph<T>(){

            @Override
            protected NodeManager<T> getNodeManager() {
                return n;
            }

            @Override
            protected EdgeManager<T> getEdgeManager() {
                return e;
            }
        };
        return output;
    }
}

