/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlowSparseNumberedGraph<T>
extends AbstractNumberedGraph<T> {
    private final SlowNumberedNodeManager<T> nodeManager = new SlowNumberedNodeManager();
    private final SparseNumberedEdgeManager<T> edgeManager;

    protected SlowSparseNumberedGraph() {
        this(0);
    }

    public SlowSparseNumberedGraph(int normalOutCount) {
        this.edgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, normalOutCount, 1);
    }

    @Override
    public NodeManager<T> getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public EdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public static <T> SlowSparseNumberedGraph<T> duplicate(Graph<T> g) {
        SlowSparseNumberedGraph<T> result = SlowSparseNumberedGraph.make();
        SlowSparseNumberedGraph.copyInto(g, result);
        return result;
    }

    public static <T> void copyInto(Graph<T> g, Graph<T> into) {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        Iterator it = g.iterator();
        while (it.hasNext()) {
            into.addNode(it.next());
        }
        for (Object n : g) {
            Iterator it2 = g.getSuccNodes(n);
            while (it2.hasNext()) {
                into.addEdge(n, it2.next());
            }
        }
    }

    public static <T> SlowSparseNumberedGraph<T> make() {
        return new SlowSparseNumberedGraph<T>();
    }
}

