/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.labeled;

import com.ibm.wala.demandpa.genericutil.ArraySet;
import com.ibm.wala.demandpa.genericutil.ArraySetMultiMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.graph.labeled.LabeledEdgeManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseNumberedLabeledEdgeManager<T, U>
implements LabeledEdgeManager<T, U> {
    private final U defaultLabel;
    private final NumberedNodeManager<T> nodeManager;
    private final Map<U, SparseNumberedEdgeManager<T>> edgeLabelToManager = HashMapFactory.make();
    private final ArraySetMultiMap<T, U> nodeToPredLabels = new ArraySetMultiMap();
    private final ArraySetMultiMap<T, U> nodeToSuccLabels = new ArraySetMultiMap();

    private SparseNumberedEdgeManager<T> getManagerForLabel(U label) {
        SparseNumberedEdgeManager<T> ret = this.edgeLabelToManager.get(label);
        if (ret == null) {
            ret = new SparseNumberedEdgeManager<T>(this.nodeManager);
            this.edgeLabelToManager.put(label, ret);
        }
        return ret;
    }

    @Override
    public void addEdge(T src, T dst, U label) {
        this.nodeToSuccLabels.put(src, label);
        this.nodeToPredLabels.put(dst, label);
        this.getManagerForLabel(label).addEdge(src, dst);
    }

    @Override
    public int getPredNodeCount(T N, U label) {
        return this.getManagerForLabel(label).getPredNodeCount(N);
    }

    @Override
    public Iterator<? extends T> getPredNodes(T N, U label) {
        return this.getManagerForLabel(label).getPredNodes(N);
    }

    @Override
    public int getSuccNodeCount(T N, U label) {
        return this.getManagerForLabel(label).getSuccNodeCount(N);
    }

    @Override
    public Iterator<? extends T> getSuccNodes(T N, U label) {
        return this.getManagerForLabel(label).getSuccNodes(N);
    }

    @Override
    public boolean hasEdge(T src, T dst, U label) {
        return this.getManagerForLabel(label).hasEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(T node) {
        this.removeIncomingEdges(node);
        this.removeOutgoingEdges(node);
    }

    @Override
    public void removeEdge(T src, T dst, U label) throws IllegalArgumentException {
        this.getManagerForLabel(label).removeEdge(src, dst);
    }

    @Override
    public void removeIncomingEdges(T node) throws IllegalArgumentException {
        for (Object label : this.nodeToPredLabels.get((Object)node)) {
            this.getManagerForLabel(label).removeIncomingEdges(node);
        }
    }

    @Override
    public void removeOutgoingEdges(T node) throws IllegalArgumentException {
        for (Object label : this.nodeToSuccLabels.get((Object)node)) {
            this.getManagerForLabel(label).removeOutgoingEdges(node);
        }
    }

    public SparseNumberedLabeledEdgeManager(NumberedNodeManager<T> nodeManager, U defaultLabel) {
        this.defaultLabel = defaultLabel;
        this.nodeManager = nodeManager;
        if (defaultLabel == null) {
            throw new IllegalArgumentException("null default label");
        }
    }

    @Override
    public Iterator<? extends U> getPredLabels(T N) {
        return ((ArraySet)this.nodeToPredLabels.get((Object)N)).iterator();
    }

    @Override
    public Iterator<? extends U> getSuccLabels(T N) {
        return ((ArraySet)this.nodeToSuccLabels.get((Object)N)).iterator();
    }

    @Override
    public Set<? extends U> getEdgeLabels(T src, T dst) {
        Set labels = HashSetFactory.make();
        for (U key : this.edgeLabelToManager.keySet()) {
            if (!this.edgeLabelToManager.get(key).hasEdge(src, dst)) continue;
            labels.add(key);
        }
        return labels;
    }

    @Override
    public void addEdge(T src, T dst) {
        this.addEdge(src, dst, this.defaultLabel);
    }

    @Override
    public int getPredNodeCount(T N) {
        int count = 0;
        for (Object label : this.nodeToPredLabels.get((Object)N)) {
            count += this.getPredNodeCount(N, label);
        }
        return count;
    }

    @Override
    public Iterator<? extends T> getPredNodes(T N) {
        Collection preds = HashSetFactory.make();
        for (Object label : this.nodeToPredLabels.get((Object)N)) {
            preds.addAll((Collection)Iterator2Collection.toCollection(this.getPredNodes(N, label)));
        }
        return preds.iterator();
    }

    @Override
    public int getSuccNodeCount(T N) {
        int count = 0;
        for (Object label : this.nodeToSuccLabels.get((Object)N)) {
            count += this.getSuccNodeCount(N, label);
        }
        return count;
    }

    @Override
    public Iterator<? extends T> getSuccNodes(T N) {
        Collection succs = HashSetFactory.make();
        for (Object label : this.nodeToSuccLabels.get((Object)N)) {
            succs.addAll((Collection)Iterator2Collection.toCollection(this.getSuccNodes(N, label)));
        }
        return succs.iterator();
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        return this.hasEdge(src, dst, this.defaultLabel);
    }

    @Override
    public void removeEdge(T src, T dst) throws UnsupportedOperationException {
        this.removeEdge(src, dst, this.defaultLabel);
    }

    @Override
    public U getDefaultLabel() {
        return this.defaultLabel;
    }
}

