/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFSPathFinder<T> {
    private final boolean DEBUG = false;
    private final Graph<T> G;
    private final Filter<T> filter;
    private final Iterator<T> roots;

    public BFSPathFinder(Graph<T> G, T N, Filter<T> f) {
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(N);
        this.filter = f;
    }

    public BFSPathFinder(Graph<T> G, T src, final T target) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(src);
        if (!G.containsNode(src)) {
            throw new IllegalArgumentException("src is not in graph " + src);
        }
        this.filter = new Filter<T>(){

            @Override
            public boolean accepts(T o) {
                return target.equals(o);
            }
        };
    }

    public BFSPathFinder(Graph<T> G, T src, Iterator<T> targets) {
        final Set ts = HashSetFactory.make();
        while (targets.hasNext()) {
            ts.add(targets.next());
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(src);
        this.filter = new Filter<T>(){

            @Override
            public boolean accepts(T o) {
                return ts.contains(o);
            }
        };
    }

    public BFSPathFinder(Graph<T> G, Iterator<T> sources, final T target) {
        this.G = G;
        this.roots = sources;
        this.filter = new Filter<T>(){

            @Override
            public boolean accepts(T o) {
                return target.equals(o);
            }
        };
    }

    public BFSPathFinder(Graph<T> G, Iterator<T> nodes, Filter<T> f) {
        this.G = G;
        this.roots = nodes;
        this.filter = f;
    }

    public List<T> find() {
        LinkedList<Object> Q = new LinkedList<Object>();
        HashMap history = HashMapFactory.make();
        while (this.roots.hasNext()) {
            T next = this.roots.next();
            Q.addLast(next);
            history.put(next, null);
        }
        while (!Q.isEmpty()) {
            Object N = Q.removeFirst();
            if (this.filter.accepts(N)) {
                return this.makePath(N, history);
            }
            Iterator children = this.getConnected(N);
            while (children.hasNext()) {
                Object c = children.next();
                if (history.containsKey(c)) continue;
                Q.addLast(c);
                history.put(c, N);
            }
        }
        return null;
    }

    private List<T> makePath(T node, Map<Object, T> history) {
        ArrayList<T> result = new ArrayList<T>();
        T n = node;
        result.add(n);
        T parent;
        while ((parent = history.get(n)) != null) {
            result.add(parent);
            n = parent;
        }
        return result;
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }
}

