/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedBFSIterator<T>
implements Iterator<T> {
    final ArrayList<T> Q = new ArrayList();
    final HashSet<T> visited = HashSetFactory.make();
    private int index = 0;
    protected Graph<T> G;
    private final int k;
    private final int[] boundary;
    private int currentHops = 0;

    public BoundedBFSIterator(Graph<T> G, T N, int k) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.k = k;
        this.boundary = new int[k];
        this.init(G, new NonNullSingletonIterator<T>(N));
    }

    public BoundedBFSIterator(Graph<T> G, Iterator<? extends T> nodes, int k) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.k = k;
        this.boundary = new int[k];
        this.init(G, nodes);
    }

    /*
     * Unable to fully structure code
     */
    private void init(Graph<T> G, Iterator<? extends T> nodes) {
        this.G = G;
        if (G.getNumberOfNodes() != 0) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            o = nodes.next();
            if (this.visited.contains(o)) continue;
            this.Q.add(o);
            this.visited.add(o);
lbl10:
            // 3 sources

            ** while (nodes.hasNext())
        }
lbl11:
        // 1 sources

        this.index = 0;
        current = this.Q.get(0);
        this.visitChildren(current);
    }

    private void visitChildren(T N) {
        if (this.currentHops == this.k) {
            return;
        }
        if (this.boundary[this.currentHops] == 0) {
            this.boundary[this.currentHops] = this.Q.size();
        }
        Iterator<T> children = this.getConnected(N);
        while (children.hasNext()) {
            T child = children.next();
            if (this.visited.contains(child)) continue;
            this.Q.add(child);
            this.visited.add(child);
        }
    }

    @Override
    public boolean hasNext() {
        return this.Q.size() > this.index;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.Q.get(this.index);
        ++this.index;
        if (this.currentHops < this.k && this.index == this.boundary[this.currentHops]) {
            ++this.currentHops;
        }
        if (this.hasNext()) {
            T N = this.Q.get(this.index);
            this.visitChildren(N);
        }
        return result;
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getCurrentHops() {
        return this.currentHops;
    }
}

