/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DFSDiscoverTimeIterator<T>
extends Stack<T>
implements Iterator<T> {
    private Iterator<? extends T> roots;

    protected void init(Iterator<? extends T> nodes) {
        this.roots = nodes;
        if (this.roots.hasNext()) {
            T n = this.roots.next();
            this.push(n);
            this.setPendingChildren(n, this.getConnected(n));
        }
    }

    protected void init(T N) {
        this.init((T)new NonNullSingletonIterator<T>(N));
    }

    @Override
    public boolean hasNext() {
        return !this.empty();
    }

    protected abstract Iterator<? extends T> getPendingChildren(T var1);

    protected abstract void setPendingChildren(T var1, Iterator<? extends T> var2);

    @Override
    public T next() throws NoSuchElementException {
        if (this.empty()) {
            throw new NoSuchElementException();
        }
        Object toReturn = this.peek();
        Assertions._assert(this.getPendingChildren(toReturn) != null);
        do {
            Object stackTop = this.peek();
            Iterator it = this.getPendingChildren(stackTop);
            while (it.hasNext()) {
                Object child = it.next();
                if (this.getPendingChildren(child) != null) continue;
                this.visitEdge(stackTop, child);
                this.setPendingChildren(child, this.getConnected(child));
                this.push(child);
                return (T)toReturn;
            }
            Iterator empty = EmptyIterator.instance();
            this.setPendingChildren(stackTop, empty);
            this.pop();
        } while (!this.empty());
        while (this.roots.hasNext()) {
            T nextRoot = this.roots.next();
            if (this.getPendingChildren(nextRoot) != null) continue;
            this.push(nextRoot);
            this.setPendingChildren(nextRoot, this.getConnected(nextRoot));
            return (T)toReturn;
        }
        return (T)toReturn;
    }

    protected abstract Iterator<? extends T> getConnected(T var1);

    @Override
    public void remove() throws UnimplementedError {
        throw new UnimplementedError();
    }

    protected void visitEdge(T from, T to) {
    }
}

