/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFSPathFinder<T>
extends Stack<T> {
    public static final long serialVersionUID = 9939900773328288L;
    private final Graph<T> G;
    private final Filter<T> filter;
    private final Iterator<T> roots;
    private final Map<T, Iterator<? extends T>> pendingChildren = HashMapFactory.make(25);
    private boolean initialized = false;

    public DFSPathFinder(Graph<T> G, T N, Filter<T> f) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!G.containsNode(N)) {
            throw new IllegalArgumentException("source node not in graph: " + N);
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(N);
        this.filter = f;
    }

    public DFSPathFinder(Graph<T> G, Iterator<T> nodes, Filter<T> f) {
        this.G = G;
        this.roots = nodes;
        this.filter = f;
    }

    private void init() {
        this.initialized = true;
        if (this.roots.hasNext()) {
            T n = this.roots.next();
            this.push(n);
            this.setPendingChildren(n, this.getConnected(n));
        }
    }

    public List find() {
        if (!this.initialized) {
            this.init();
        }
        while (this.hasNext()) {
            Object n = this.peek();
            if (this.filter.accepts(n)) {
                List<T> path = this.currentPath();
                this.advance();
                return path;
            }
            this.advance();
        }
        return null;
    }

    private List<T> currentPath() {
        ArrayList result = new ArrayList();
        Iterator path = this.iterator();
        while (path.hasNext()) {
            result.add(0, path.next());
        }
        return result;
    }

    public boolean hasNext() {
        return !this.empty();
    }

    private Iterator<? extends T> getPendingChildren(T n) {
        return this.pendingChildren.get(n);
    }

    private void setPendingChildren(T v, Iterator<? extends T> iterator) {
        this.pendingChildren.put(v, iterator);
    }

    private void advance() {
        Object currentNode = this.peek();
        Assertions._assert(this.getPendingChildren(currentNode) != null);
        do {
            Object stackTop = this.peek();
            Iterator it = this.getPendingChildren(stackTop);
            while (it.hasNext()) {
                Object child = it.next();
                if (this.getPendingChildren(child) != null) continue;
                this.setPendingChildren(child, this.getConnected(child));
                this.push(child);
                return;
            }
            this.pop();
        } while (!this.empty());
        while (this.roots.hasNext()) {
            T nextRoot = this.roots.next();
            if (this.getPendingChildren(nextRoot) != null) continue;
            this.push(nextRoot);
            this.setPendingChildren(nextRoot, this.getConnected(nextRoot));
        }
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }
}

