/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.GraphDFSDiscoverTimeIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberedDFSDiscoverTimeIterator<T>
extends GraphDFSDiscoverTimeIterator<T>
implements Iterator<T> {
    private static final long serialVersionUID = -3919708273323217304L;
    private final Iterator<? extends T>[] pendingChildren;
    protected final NumberedGraph<T> G;

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> G, T N) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, new NonNullSingletonIterator<T>(N));
    }

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> G, Iterator<? extends T> nodes) throws IllegalArgumentException {
        if (nodes == null) {
            throw new IllegalArgumentException("nodes == null");
        }
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, nodes);
    }

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> G) throws NullPointerException {
        this(G, G.iterator());
    }

    @Override
    protected Iterator<? extends T> getPendingChildren(T n) {
        return this.pendingChildren[this.G.getNumber(n)];
    }

    @Override
    protected void setPendingChildren(T v, Iterator<? extends T> iterator) {
        this.pendingChildren[this.G.getNumber(v)] = iterator;
    }
}

