/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberedDFSFinishTimeIterator<T>
extends DFSFinishTimeIterator<T>
implements Iterator<T> {
    public static final long serialVersionUID = 8737376661L;
    private Iterator[] pendingChildren;
    private final NumberedGraph<T> G;

    NumberedDFSFinishTimeIterator(NumberedGraph<T> G, T N) {
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, new NonNullSingletonIterator<T>(N));
    }

    NumberedDFSFinishTimeIterator(NumberedGraph<T> G, Iterator<? extends T> nodes) {
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, nodes);
    }

    NumberedDFSFinishTimeIterator(NumberedGraph<T> G) {
        this(G, G.iterator());
    }

    @Override
    Iterator getPendingChildren(T n) {
        int number = this.G.getNumber(n);
        if (number >= this.pendingChildren.length) {
            Iterator[] old = this.pendingChildren;
            this.pendingChildren = new Iterator[number * 2];
            System.arraycopy(old, 0, this.pendingChildren, 0, old.length);
            return null;
        }
        if (number < 0) {
            Assertions._assert(false, "negative number for " + n + " " + n.getClass());
        }
        return this.pendingChildren[number];
    }

    @Override
    void setPendingChildren(T v, Iterator<? extends T> iterator) {
        this.pendingChildren[this.G.getNumber(v)] = iterator;
    }
}

