/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.ReverseIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCCIterator<T>
implements Iterator<Set<T>> {
    private final DFSFinishTimeIterator<T> rev;

    public SCCIterator(Graph<T> G) throws NullPointerException {
        this(G, G.iterator());
    }

    public SCCIterator(Graph<T> G, Iterator<T> nodes) {
        Iterator reverseFinishTime = ReverseIterator.reverse(DFS.iterateFinishTime(G, nodes));
        this.rev = DFS.iterateFinishTime(GraphInverter.invert(G), reverseFinishTime);
    }

    @Override
    public boolean hasNext() {
        return this.rev.hasNext();
    }

    @Override
    public Set<T> next() throws NoSuchElementException {
        Set currentSCC = HashSetFactory.make();
        T v = this.rev.next();
        currentSCC.add(v);
        while (this.rev.hasNext() && !this.rev.isEmpty()) {
            currentSCC.add(this.rev.next());
        }
        return currentSCC;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

