/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.TunedMutableSparseIntSet;

public class BimodalMutableIntSet
implements MutableIntSet {
    MutableIntSet impl;

    public void copySet(IntSet set) {
        if (set instanceof BimodalMutableIntSet) {
            this.impl = IntSetUtil.makeMutableCopy(((BimodalMutableIntSet)set).impl);
        } else if (this.sameRepresentation(this.impl, set)) {
            this.impl.copySet(set);
        } else if (set instanceof BitVectorIntSet || set instanceof SparseIntSet) {
            this.impl = IntSetUtil.makeMutableCopy(set);
        } else if (set instanceof MutableSharedBitVectorIntSet) {
            this.impl = IntSetUtil.makeMutableCopy(((MutableSharedBitVectorIntSet)set).makeSparseCopy());
        } else {
            Assertions.UNREACHABLE("Unexpected type " + set.getClass());
        }
        Assertions._assert(this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
    }

    private boolean sameRepresentation(IntSet V, IntSet W) {
        return V.getClass().equals(W.getClass());
    }

    public boolean addAll(IntSet set) {
        boolean result;
        if (set instanceof BitVectorIntSet && !(this.impl instanceof BitVectorIntSet)) {
            this.impl = new BitVectorIntSet(this.impl);
        }
        if (result = this.impl.addAll(set)) {
            this.maybeChangeRepresentation();
        }
        return result;
    }

    public boolean addAllInIntersection(IntSet other, IntSet filter) {
        boolean result;
        if (other instanceof BitVectorIntSet && !(this.impl instanceof BitVectorIntSet)) {
            this.impl = new BitVectorIntSet(this.impl);
        }
        if (result = this.impl.addAllInIntersection(other, filter)) {
            this.maybeChangeRepresentation();
        }
        return result;
    }

    private void maybeChangeRepresentation() {
        Assertions._assert(this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
        if (this.impl == null) {
            return;
        }
        int sparseSize = this.impl.size();
        if (sparseSize <= 2) {
            return;
        }
        int bvSize = BitVectorBase.subscript(this.impl.max()) + 1;
        if (sparseSize > bvSize) {
            if (!(this.impl instanceof BitVectorIntSet)) {
                this.impl = new BitVectorIntSet(this.impl);
            }
        } else if (!(this.impl instanceof MutableSparseIntSet)) {
            this.impl = MutableSparseIntSet.make(this.impl);
        }
        Assertions._assert(this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
    }

    public boolean add(int i) {
        boolean result = this.impl.add(i);
        if (result) {
            this.maybeChangeRepresentation();
        }
        return result;
    }

    public boolean remove(int i) {
        boolean result = this.impl.remove(i);
        this.maybeChangeRepresentation();
        return result;
    }

    public void intersectWith(IntSet set) throws UnimplementedError {
        if (set instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet that = (BimodalMutableIntSet)set;
            this.impl.intersectWith(that.impl);
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public boolean contains(int i) {
        return this.impl.contains(i);
    }

    public IntSet intersection(IntSet that) throws UnimplementedError {
        if (that instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet b = (BimodalMutableIntSet)that;
            return this.impl.intersection(b.impl);
        }
        if (that instanceof BitVectorIntSet) {
            return this.impl.intersection(that);
        }
        Assertions.UNREACHABLE("Unexpected: " + that);
        return null;
    }

    public IntSet union(IntSet that) {
        BimodalMutableIntSet temp = new BimodalMutableIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public int size() {
        return this.impl.size();
    }

    public IntIterator intIterator() {
        return this.impl.intIterator();
    }

    public void foreach(IntSetAction action) {
        this.impl.foreach(action);
    }

    public void foreachExcluding(IntSet X, IntSetAction action) {
        this.impl.foreachExcluding(X, action);
    }

    public int max() throws IllegalStateException {
        return this.impl.max();
    }

    public static BimodalMutableIntSet makeCopy(IntSet B) throws UnimplementedError, IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        if (B instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet that = (BimodalMutableIntSet)B;
            BimodalMutableIntSet result = new BimodalMutableIntSet();
            result.impl = IntSetUtil.makeMutableCopy(that.impl);
            return result;
        }
        if (B instanceof MutableSharedBitVectorIntSet) {
            BimodalMutableIntSet result = new BimodalMutableIntSet();
            MutableSharedBitVectorIntSet s = (MutableSharedBitVectorIntSet)B;
            result.impl = IntSetUtil.makeMutableCopy(s.makeSparseCopy());
            Assertions._assert(result.impl instanceof BitVectorIntSet || result.impl instanceof MutableSparseIntSet);
            return result;
        }
        BimodalMutableIntSet result = new BimodalMutableIntSet();
        result.impl = IntSetUtil.makeMutableCopy(B);
        Assertions._assert(result.impl instanceof BitVectorIntSet || result.impl instanceof MutableSparseIntSet);
        return result;
    }

    public BimodalMutableIntSet() {
        this.impl = MutableSparseIntSet.makeEmpty();
    }

    public BimodalMutableIntSet(int initialSize, float expansionFactor) {
        this.impl = new TunedMutableSparseIntSet(initialSize, expansionFactor);
    }

    public BimodalMutableIntSet(BimodalMutableIntSet x) {
        if (x == null) {
            throw new IllegalArgumentException("x is null");
        }
        this.impl = IntSetUtil.makeMutableCopy(x.impl);
        Assertions._assert(this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
    }

    public boolean sameValue(IntSet that) {
        return this.impl.sameValue(that);
    }

    public boolean isSubset(IntSet that) throws IllegalArgumentException {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet b = (BimodalMutableIntSet)that;
            return this.impl.isSubset(b.impl);
        }
        BitVectorIntSet a = new BitVectorIntSet(this);
        BitVectorIntSet b = new BitVectorIntSet(that);
        return a.isSubset(b);
    }

    public IntSet getBackingStore() {
        return this.impl;
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean containsAny(IntSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet b = (BimodalMutableIntSet)that;
            return this.impl.containsAny(b.impl);
        }
        if (that instanceof SparseIntSet) {
            return this.impl.containsAny(that);
        }
        if (that instanceof BitVectorIntSet) {
            return this.impl.containsAny(that);
        }
        Assertions.UNREACHABLE("unsupported " + that.getClass());
        return false;
    }

    public boolean removeAll(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("that is null");
        }
        boolean result = false;
        IntIterator it = that.intIterator();
        while (it.hasNext()) {
            result |= this.remove(it.next());
        }
        return result;
    }

    public boolean containsAll(BimodalMutableIntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("that is null");
        }
        IntIterator it = that.intIterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }
}

