/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.DeterministicHashCode;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public final class BitVectorIntSet
implements MutableIntSet {
    private int populationCount = 0;
    private static final int UNDEFINED = -1;
    private BitVector bitVector = new BitVector(0);
    private final int hash;

    public BitVectorIntSet() {
        this.hash = DeterministicHashCode.get();
    }

    public BitVectorIntSet(BitVector v) {
        this.hash = DeterministicHashCode.get();
        this.bitVector.or(v);
        this.populationCount = -1;
    }

    public BitVectorIntSet(IntSet S) throws IllegalArgumentException {
        if (S == null) {
            throw new IllegalArgumentException("S == null");
        }
        this.copySet(S);
        this.hash = DeterministicHashCode.get();
    }

    public void copySet(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof BitVectorIntSet) {
            BitVectorIntSet S = (BitVectorIntSet)set;
            this.bitVector = new BitVector(S.bitVector);
            this.populationCount = S.populationCount;
        } else if (set instanceof MutableSharedBitVectorIntSet) {
            BitVectorIntSet S = ((MutableSharedBitVectorIntSet)set).makeDenseCopy();
            this.bitVector = new BitVector(S.bitVector);
            this.populationCount = S.populationCount;
        } else if (set instanceof SparseIntSet) {
            SparseIntSet s = (SparseIntSet)set;
            if (s.size == 0) {
                this.populationCount = 0;
                this.bitVector = new BitVector(0);
            } else {
                this.bitVector = new BitVector(s.max());
                this.populationCount = s.size;
                int i = 0;
                while (i < s.size) {
                    this.bitVector.set(s.elements[i]);
                    ++i;
                }
            }
        } else if (set instanceof BimodalMutableIntSet) {
            IntSet backing = ((BimodalMutableIntSet)set).getBackingStore();
            this.copySet(backing);
        } else {
            this.bitVector.clearAll();
            this.populationCount = set.size();
            IntIterator it = set.intIterator();
            while (it.hasNext()) {
                this.bitVector.set(it.next());
            }
        }
    }

    public boolean addAll(IntSet set) {
        if (set instanceof BitVectorIntSet) {
            BitVector B = ((BitVectorIntSet)set).bitVector;
            int delta = this.bitVector.orWithDelta(B);
            this.populationCount += delta;
            int n = this.populationCount = this.populationCount == delta + -1 ? -1 : this.populationCount;
            return delta != 0;
        }
        BitVectorIntSet other = new BitVectorIntSet(set);
        return this.addAll(other);
    }

    public void addAllOblivious(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof BitVectorIntSet) {
            BitVector B = ((BitVectorIntSet)set).bitVector;
            this.bitVector.or(B);
            this.populationCount = -1;
        } else {
            BitVectorIntSet other = new BitVectorIntSet(set);
            this.addAllOblivious(other);
        }
    }

    public boolean add(int i) {
        if (this.bitVector.get(i)) {
            return false;
        }
        this.bitVector.set(i);
        ++this.populationCount;
        this.populationCount = this.populationCount == 0 ? -1 : this.populationCount;
        return true;
    }

    public boolean remove(int i) {
        if (this.contains(i)) {
            --this.populationCount;
            this.populationCount = this.populationCount == -2 ? -1 : this.populationCount;
            this.bitVector.clear(i);
            return true;
        }
        return false;
    }

    public void intersectWith(IntSet set) {
        if (!(set instanceof BitVectorIntSet)) {
            set = new BitVectorIntSet(set);
        }
        BitVector B = ((BitVectorIntSet)set).bitVector;
        this.bitVector.and(B);
        this.populationCount = -1;
    }

    public IntSet intersection(IntSet that) {
        BitVectorIntSet newbie = new BitVectorIntSet();
        newbie.copySet(this);
        newbie.intersectWith(that);
        return newbie;
    }

    public IntSet union(IntSet that) {
        BitVectorIntSet temp = new BitVectorIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        return this.populationCount;
    }

    public IntIterator intIterator() {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        return new IntIterator(){
            int count = 0;
            int last = 0;

            public boolean hasNext() {
                return this.count < BitVectorIntSet.this.populationCount;
            }

            public int next() {
                ++this.count;
                this.last = BitVectorIntSet.this.nextSetBit(this.last) + 1;
                return this.last - 1;
            }
        };
    }

    public void foreach(IntSetAction action) {
        int nextBit = this.bitVector.nextSetBit(0);
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        int i = 0;
        while (i < this.populationCount) {
            action.act(nextBit);
            nextBit = this.bitVector.nextSetBit(nextBit + 1);
            ++i;
        }
    }

    public SparseIntSet makeSparseCopy() {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        int[] elements = new int[this.populationCount];
        int i = 0;
        int nextBit = -1;
        while (i < this.populationCount) {
            elements[i++] = nextBit = this.bitVector.nextSetBit(nextBit + 1);
        }
        return new SparseIntSet(elements);
    }

    public void foreachExcluding(IntSet X, IntSetAction action) {
        if (X instanceof BitVectorIntSet) {
            this.fastForeachExcluding((BitVectorIntSet)X, action);
        } else {
            this.slowForeachExcluding(X, action);
        }
    }

    private void slowForeachExcluding(IntSet X, IntSetAction action) {
        this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        int i = 0;
        int count = 0;
        while (count < this.populationCount) {
            if (this.contains(i)) {
                if (!X.contains(i)) {
                    action.act(i);
                }
                ++count;
            }
            ++i;
        }
    }

    private void fastForeachExcluding(BitVectorIntSet X, IntSetAction action) {
        int[] bits = this.bitVector.bits;
        int[] xbits = X.bitVector.bits;
        int w = 0;
        while (w < xbits.length && w < bits.length) {
            int b = bits[w] & ~xbits[w];
            this.actOnWord(action, w << 5, b);
            ++w;
        }
        while (w < bits.length) {
            this.actOnWord(action, w << 5, bits[w]);
            ++w;
        }
    }

    private void actOnWord(IntSetAction action, int startingIndex, int word) {
        if (word != 0) {
            if ((word & 1) != 0) {
                action.act(startingIndex);
            }
            int i = 0;
            while (i < 31) {
                ++startingIndex;
                if (((word >>>= 1) & 1) != 0) {
                    action.act(startingIndex);
                }
                ++i;
            }
        }
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean contains(int i) {
        Assertions._assert(i >= 0);
        return this.bitVector.get(i);
    }

    public int max() {
        return this.bitVector.max();
    }

    public String toString() {
        return this.bitVector.toString();
    }

    public int nextSetBit(int n) {
        return this.bitVector.nextSetBit(n);
    }

    public boolean sameValue(IntSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof BitVectorIntSet) {
            BitVectorIntSet b = (BitVectorIntSet)that;
            return this.bitVector.sameBits(b.bitVector);
        }
        if (that instanceof BimodalMutableIntSet) {
            return that.sameValue(this);
        }
        if (that instanceof SparseIntSet) {
            return this.sameValueInternal((SparseIntSet)that);
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue(((MutableSharedBitVectorIntSet)that).makeDenseCopy());
        }
        Assertions.UNREACHABLE("unexpected argument type " + that.getClass());
        return false;
    }

    private boolean sameValueInternal(SparseIntSet that) {
        int n = this.populationCount = this.populationCount == -1 ? this.bitVector.populationCount() : this.populationCount;
        if (this.populationCount != that.size()) {
            return false;
        }
        int i = 0;
        while (i < that.size()) {
            int val = that.elementAt(i);
            if (!this.bitVector.contains(val)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSubset(IntSet that) {
        if (that instanceof BitVectorIntSet) {
            return this.bitVector.isSubset(((BitVectorIntSet)that).bitVector);
        }
        if (that instanceof SparseIntSet) {
            return this.isSubsetInternal((SparseIntSet)that);
        }
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            int x = it.next();
            if (that.contains(x)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubsetInternal(SparseIntSet set) {
        return this.toSparseIntSet().isSubset(set);
    }

    public BitVector getBitVector() {
        return this.bitVector;
    }

    public SparseIntSet toSparseIntSet() {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public boolean removeAll(BitVectorIntSet set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int oldSize = this.size();
        this.bitVector.andNot(set.bitVector);
        this.populationCount = -1;
        return oldSize > this.size();
    }

    public boolean containsAny(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof BitVectorIntSet) {
            BitVectorIntSet b = (BitVectorIntSet)set;
            return !this.bitVector.intersectionEmpty(b.bitVector);
        }
        IntIterator it = set.intIterator();
        while (it.hasNext()) {
            if (!this.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean addAllInIntersection(IntSet other, IntSet filter) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        BitVectorIntSet o = new BitVectorIntSet(other);
        o.intersectWith(filter);
        return this.addAll(o);
    }

    public boolean containsAll(BitVectorIntSet other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        return other.isSubset(this);
    }
}

