/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.annotations.Internal;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.SparseIntSet;

@Internal
public class DebuggingMutableIntSetFactory
implements MutableIntSetFactory {
    private MutableIntSetFactory primary;
    private MutableIntSetFactory secondary;

    public DebuggingMutableIntSetFactory(MutableIntSetFactory p, MutableIntSetFactory s) {
        this.primary = p;
        this.secondary = s;
    }

    public DebuggingMutableIntSetFactory() {
        this(new MutableSparseIntSetFactory(), new MutableSharedBitVectorIntSetFactory());
    }

    public MutableIntSet make(int[] set) {
        return new DebuggingMutableIntSet(this.primary.make(set), this.secondary.make(set));
    }

    public MutableIntSet parse(String string) {
        int[] backingStore = SparseIntSet.parseIntArray(string);
        return this.make(backingStore);
    }

    public MutableIntSet makeCopy(IntSet x) throws UnimplementedError {
        if (x instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)x;
            MutableIntSet pr = this.primary.makeCopy(db.primaryImpl);
            MutableIntSet sr = this.secondary.makeCopy(db.secondaryImpl);
            Assertions._assert(pr.sameValue(db.primaryImpl));
            Assertions._assert(sr.sameValue(db.secondaryImpl));
            Assertions._assert(pr.sameValue(sr));
            return new DebuggingMutableIntSet(pr, sr);
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public MutableIntSet make() {
        return new DebuggingMutableIntSet(this.primary.make(), this.secondary.make());
    }

    public void setPrimaryFactory(MutableIntSetFactory x) {
        this.primary = x;
    }

    public void setSecondaryFactory(MutableIntSetFactory x) {
        this.secondary = x;
    }
}

