/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;

public class IntegerUnionFind {
    private static final int DEFAULT_SIZE = 100;
    int[] parent;

    public IntegerUnionFind() {
        this(100);
    }

    public IntegerUnionFind(int size) {
        this.parent = new int[size + 1];
    }

    public void union(int x, int y) {
        Assertions._assert(x >= 0);
        Assertions._assert(y >= 0);
        if (x >= this.size() || y >= this.size()) {
            this.grow(2 * Math.max(x, y));
        }
        ++x;
        ++y;
        if ((x = this.findInternal(x)) != (y = this.findInternal(y))) {
            if (this.parent[x] < this.parent[y]) {
                int n = x;
                this.parent[n] = this.parent[n] + (this.parent[y] - 1);
                this.parent[y] = x;
            } else {
                int n = y;
                this.parent[n] = this.parent[n] + (this.parent[x] - 1);
                this.parent[x] = y;
            }
        }
    }

    private void grow(int size) {
        int[] old = this.parent;
        this.parent = new int[size + 1];
        System.arraycopy(old, 0, this.parent, 0, old.length);
    }

    public int find(int x) {
        Assertions._assert(x >= 0);
        if (x >= this.size()) {
            return x;
        }
        return this.findInternal(x + 1) - 1;
    }

    private int findInternal(int x) {
        int root = x;
        while (this.parent[root] > 0) {
            root = this.parent[root];
        }
        while (this.parent[x] > 0) {
            int z = x;
            x = this.parent[x];
            this.parent[z] = root;
        }
        return root;
    }

    public int size() {
        return this.parent.length - 1;
    }
}

