/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableSparseIntSet
extends SparseIntSet
implements MutableIntSet {
    private static final float EXPANSION_FACTOR = 1.5f;
    private static final int INITIAL_NONEMPTY_SIZE = 2;
    private static final boolean DEBUG_LARGE = false;
    private static final int TRAP_SIZE = 1000;

    private MutableSparseIntSet(IntSet set) {
        this.copySet(set);
    }

    public MutableSparseIntSet(int[] backingStore) {
        super(backingStore);
    }

    public MutableSparseIntSet(int initialCapacity) throws IllegalArgumentException {
        super(new int[initialCapacity]);
        this.size = 0;
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("initialCapacity must be positive");
        }
    }

    protected MutableSparseIntSet() {
    }

    @Override
    public boolean remove(int value) {
        if (this.elements != null) {
            int remove = 0;
            while (remove < this.size) {
                if (this.elements[remove] >= value) break;
                ++remove;
            }
            if (remove == this.size) {
                return false;
            }
            if (this.elements[remove] == value) {
                if (this.size == 1) {
                    this.elements = null;
                    this.size = 0;
                } else {
                    if (remove < this.size) {
                        System.arraycopy(this.elements, remove + 1, this.elements, remove, this.size - remove - 1);
                    }
                    --this.size;
                }
                return true;
            }
        }
        return false;
    }

    public int getInitialNonEmptySize() {
        return 2;
    }

    public float getExpansionFactor() {
        return 1.5f;
    }

    @Override
    public boolean add(int value) {
        int insert;
        Assertions._assert(value >= 0);
        if (this.elements == null) {
            this.elements = new int[this.getInitialNonEmptySize()];
            this.size = 1;
            this.elements[0] = value;
            return true;
        }
        if (this.size == 0 || value > this.max()) {
            insert = this.size;
        } else {
            if (value == this.max()) {
                return false;
            }
            insert = 0;
            while (insert < this.size) {
                if (this.elements[insert] >= value) break;
                ++insert;
            }
        }
        if (insert < this.size && this.elements[insert] == value) {
            return false;
        }
        if (this.size < this.elements.length - 1) {
            if (this.size != insert) {
                System.arraycopy(this.elements, insert, this.elements, insert + 1, this.size - insert);
            }
            ++this.size;
            this.elements[insert] = value;
            return true;
        }
        float newExtent = (float)this.elements.length * this.getExpansionFactor() + 1.0f;
        int[] tmp = new int[(int)newExtent];
        System.arraycopy(this.elements, 0, tmp, 0, insert);
        if (this.size != insert) {
            System.arraycopy(this.elements, insert, tmp, insert + 1, this.size - insert);
        }
        tmp[insert] = value;
        ++this.size;
        this.elements = tmp;
        return true;
    }

    @Override
    public void copySet(IntSet that) throws IllegalArgumentException {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseIntSet) {
            SparseIntSet set = (SparseIntSet)that;
            if (set.elements != null) {
                this.elements = (int[])set.elements.clone();
                this.size = set.size;
            } else {
                this.elements = null;
                this.size = 0;
            }
        } else {
            this.elements = new int[that.size()];
            this.size = that.size();
            that.foreach(new IntSetAction(){
                private int index = 0;

                public void act(int i) {
                    MutableSparseIntSet.this.elements[this.index++] = i;
                }
            });
        }
    }

    @Override
    public void intersectWith(IntSet set) {
        if (set instanceof SparseIntSet) {
            this.intersectWith((SparseIntSet)set);
        } else {
            int j = 0;
            int i = 0;
            while (i < this.size) {
                if (set.contains(this.elements[i])) {
                    this.elements[j++] = this.elements[i];
                }
                ++i;
            }
            this.size = j;
        }
    }

    public void intersectWith(SparseIntSet set) {
        SparseIntSet that = set;
        Assertions._assert(that != null);
        if (this.isEmpty()) {
            return;
        }
        if (that.isEmpty()) {
            this.elements = null;
            this.size = 0;
            return;
        }
        if (this.equals(that)) {
            return;
        }
        if (this.size == 1) {
            if (that.contains(this.elements[0])) {
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        if (that.size == 1) {
            if (this.contains(that.elements[0])) {
                if (this.size > this.getInitialNonEmptySize()) {
                    this.elements = new int[this.getInitialNonEmptySize()];
                }
                this.size = 1;
                this.elements[0] = that.elements[0];
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        int[] ar = this.elements;
        int ai = 0;
        int al = this.size;
        int[] br = that.elements;
        int bi = 0;
        int bl = that.size;
        int[] cr = null;
        int ci = 0;
        while (ai < al && bi < bl) {
            int cmp = ar[ai] - br[bi];
            if (cmp > 0) {
                ++bi;
                continue;
            }
            if (cmp < 0) {
                ++ai;
                continue;
            }
            if (cr == null) {
                cr = new int[al];
            }
            cr[ci++] = ar[ai];
            ++ai;
            ++bi;
        }
        this.size = ci;
        this.elements = cr;
    }

    @Override
    public boolean addAll(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof SparseIntSet) {
            return this.addAll((SparseIntSet)set);
        }
        int oldSize = this.size;
        set.foreach(new IntSetAction(){

            public void act(int i) {
                if (!MutableSparseIntSet.this.contains(i)) {
                    MutableSparseIntSet.this.add(i);
                }
            }
        });
        return this.size != oldSize;
    }

    public boolean addAll(SparseIntSet that) {
        if (this.isEmpty()) {
            this.copySet(that);
            return !that.isEmpty();
        }
        if (that.isEmpty()) {
            return false;
        }
        if (this.equals(that)) {
            return false;
        }
        if (that.size == 1) {
            boolean result = this.add(that.elements[0]);
            return result;
        }
        int[] br = that.elements;
        int bl = that.size();
        return this.addAll(br, bl);
    }

    private boolean addAll(int[] that, int thatSize) {
        int tail;
        int[] ar = this.elements;
        int ai = 0;
        int al = this.size();
        int bi = 0;
        int[] cr = null;
        int ci = 0;
        while (ai < al && bi < thatSize) {
            int cmp = ar[ai] - that[bi];
            if (cmp > 0) {
                if (cr == null) {
                    cr = new int[al + thatSize];
                    System.arraycopy(ar, 0, cr, 0, ci);
                }
                cr[ci++] = that[bi++];
                continue;
            }
            if (cmp < 0) {
                if (cr != null) {
                    cr[ci] = ar[ai];
                }
                ++ci;
                ++ai;
                continue;
            }
            if (cr != null) {
                cr[ci] = ar[ai];
            }
            ++ci;
            ++ai;
            ++bi;
        }
        if (ai < al) {
            tail = al - ai;
            if (cr != null) {
                System.arraycopy(ar, ai, cr, ci, tail);
            }
            ci += tail;
        } else if (bi < thatSize) {
            tail = thatSize - bi;
            if (cr == null) {
                cr = new int[al + thatSize];
                System.arraycopy(ar, 0, cr, 0, ci);
            }
            System.arraycopy(that, bi, cr, ci, tail);
            ci += tail;
        }
        Assertions._assert(ci > 0);
        this.elements = cr == null ? ar : cr;
        this.size = ci;
        return al != this.size;
    }

    public void removeAll(BitVectorIntSet v) {
        int ai = 0;
        int i = 0;
        while (i < this.size) {
            if (!v.contains(this.elements[i])) {
                this.elements[ai++] = this.elements[i];
            }
            ++i;
        }
        this.size = ai;
    }

    public <T extends BitVectorBase<T>> void removeAll(T v) {
        int ai = 0;
        int i = 0;
        while (i < this.size) {
            if (!v.get(this.elements[i])) {
                this.elements[ai++] = this.elements[i];
            }
            ++i;
        }
        this.size = ai;
    }

    public void removeAll(MutableSparseIntSet set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        IntIterator it = set.intIterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    @Override
    public boolean addAllInIntersection(IntSet other, IntSet filter) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        if (other.size() < 5) {
            boolean result = false;
            IntIterator it = other.intIterator();
            while (it.hasNext()) {
                int i = it.next();
                if (!filter.contains(i)) continue;
                result |= this.add(i);
            }
            return result;
        }
        if (filter.size() < 5) {
            boolean result = false;
            IntIterator it = filter.intIterator();
            while (it.hasNext()) {
                int i = it.next();
                if (!other.contains(i)) continue;
                result |= this.add(i);
            }
            return result;
        }
        BitVectorIntSet o = new BitVectorIntSet(other);
        o.intersectWith(filter);
        return this.addAll(o);
    }

    public static MutableSparseIntSet diff(MutableSparseIntSet A, MutableSparseIntSet B) {
        return new MutableSparseIntSet(MutableSparseIntSet.diffInternal(A, B));
    }

    public static MutableSparseIntSet make(IntSet set) {
        return new MutableSparseIntSet(set);
    }

    public static MutableSparseIntSet makeEmpty() {
        return new MutableSparseIntSet();
    }
}

