/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.SparseLongSet;

public final class MutableSparseLongSet
extends SparseLongSet
implements MutableLongSet {
    private static final float EXPANSION_FACTOR = 1.5f;
    private static final int INITIAL_NONEMPTY_SIZE = 2;

    public static MutableSparseLongSet make(LongSet set) throws UnimplementedError {
        if (!(set instanceof SparseLongSet)) {
            Assertions.UNREACHABLE("implement me");
        }
        return new MutableSparseLongSet(set);
    }

    private MutableSparseLongSet(LongSet set) {
        this.copySet(set);
    }

    public MutableSparseLongSet(long[] backingStore) {
        super(backingStore);
    }

    public MutableSparseLongSet(int initialCapacity) {
        super(new long[initialCapacity]);
        this.size = 0;
        Assertions._assert(initialCapacity > 0);
    }

    public MutableSparseLongSet() {
    }

    public void remove(long value) {
        if (this.elements != null) {
            int remove = 0;
            while (remove < this.size) {
                if (this.elements[remove] >= value) break;
                ++remove;
            }
            if (remove == this.size) {
                return;
            }
            if (this.elements[remove] == value) {
                if (this.size == 1) {
                    this.elements = null;
                    this.size = 0;
                } else {
                    if (remove < this.size) {
                        System.arraycopy(this.elements, remove + 1, this.elements, remove, this.size - remove - 1);
                    }
                    --this.size;
                }
            }
        }
    }

    public boolean add(long value) {
        int insert;
        Assertions._assert(value >= 0L);
        if (this.elements == null) {
            this.elements = new long[2];
            this.size = 1;
            this.elements[0] = value;
            return true;
        }
        if (this.size == 0 || value > this.max()) {
            insert = this.size;
        } else {
            if (value == this.max()) {
                return false;
            }
            insert = 0;
            while (insert < this.size) {
                if (this.elements[insert] >= value) break;
                ++insert;
            }
        }
        if (insert < this.size && this.elements[insert] == value) {
            return false;
        }
        if (this.size < this.elements.length - 1) {
            if (this.size != insert) {
                System.arraycopy(this.elements, insert, this.elements, insert + 1, this.size - insert);
            }
            ++this.size;
            this.elements[insert] = value;
            return true;
        }
        float newExtent = (float)this.elements.length * 1.5f + 1.0f;
        long[] tmp = new long[(int)newExtent];
        System.arraycopy(this.elements, 0, tmp, 0, insert);
        if (this.size != insert) {
            System.arraycopy(this.elements, insert, tmp, insert + 1, this.size - insert);
        }
        tmp[insert] = value;
        ++this.size;
        this.elements = tmp;
        return true;
    }

    public void copySet(LongSet that) throws UnimplementedError {
        if (that instanceof SparseLongSet) {
            SparseLongSet set = (SparseLongSet)that;
            if (set.elements != null) {
                this.elements = (long[])set.elements.clone();
                this.size = set.size;
            } else {
                this.elements = null;
                this.size = 0;
            }
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public void intersectWith(LongSet set) {
        if (set instanceof SparseLongSet) {
            this.intersectWith((SparseLongSet)set);
        } else {
            int j = 0;
            int i = 0;
            while (i < this.size) {
                if (set.contains(this.elements[i])) {
                    this.elements[j++] = this.elements[i];
                }
                ++i;
            }
            this.size = j;
        }
    }

    public void intersectWith(SparseLongSet set) {
        SparseLongSet that = set;
        Assertions._assert(that != null);
        if (this.isEmpty()) {
            return;
        }
        if (that.isEmpty()) {
            this.elements = null;
            this.size = 0;
            return;
        }
        if (this.equals(that)) {
            return;
        }
        if (this.size == 1) {
            if (that.contains(this.elements[0])) {
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        if (that.size == 1) {
            if (this.contains(that.elements[0])) {
                if (this.size > 2) {
                    this.elements = new long[2];
                }
                this.size = 1;
                this.elements[0] = that.elements[0];
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        long[] ar = this.elements;
        int ai = 0;
        int al = this.size;
        long[] br = that.elements;
        int bi = 0;
        int bl = that.size;
        long[] cr = null;
        int ci = 0;
        while (ai < al && bi < bl) {
            long cmp = ar[ai] - br[bi];
            if (cmp > 0L) {
                ++bi;
                continue;
            }
            if (cmp < 0L) {
                ++ai;
                continue;
            }
            if (cr == null) {
                cr = new long[al];
            }
            cr[ci++] = ar[ai];
            ++ai;
            ++bi;
        }
        this.size = ci;
        this.elements = cr;
    }

    public boolean addAll(LongSet set) throws UnimplementedError {
        if (set instanceof SparseLongSet) {
            return this.addAll((SparseLongSet)set);
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public boolean addAll(SparseLongSet that) {
        if (this.isEmpty()) {
            this.copySet(that);
            return !that.isEmpty();
        }
        if (that.isEmpty()) {
            return false;
        }
        if (this.equals(that)) {
            return false;
        }
        if (that.size == 1) {
            boolean result = this.add(that.elements[0]);
            return result;
        }
        long[] br = that.elements;
        int bl = that.size();
        return this.addAll(br, bl);
    }

    private boolean addAll(long[] that, int thatSize) {
        long[] ar = this.elements;
        int ai = 0;
        int al = this.size();
        int bi = 0;
        long[] cr = null;
        int ci = 0;
        while (ai < al && bi < thatSize) {
            long cmp = ar[ai] - that[bi];
            if (cmp > 0L) {
                if (cr == null) {
                    cr = new long[al + thatSize];
                    System.arraycopy(ar, 0, cr, 0, ci);
                }
                cr[ci++] = that[bi++];
                continue;
            }
            if (cmp < 0L) {
                if (cr != null) {
                    cr[ci] = ar[ai];
                }
                ++ci;
                ++ai;
                continue;
            }
            if (cr != null) {
                cr[ci] = ar[ai];
            }
            ++ci;
            ++ai;
            ++bi;
        }
        if (ai < al) {
            int tail = al - ai;
            if (cr != null) {
                System.arraycopy(ar, ai, cr, ci, tail);
            }
            ci += tail;
        } else if (bi < thatSize) {
            int tail = thatSize - bi;
            if (cr == null) {
                cr = new long[al + thatSize];
                System.arraycopy(ar, 0, cr, 0, ci);
            }
            System.arraycopy(that, bi, cr, ci, tail);
            ci += tail;
        }
        Assertions._assert(ci > 0);
        this.elements = cr == null ? ar : cr;
        this.size = ci;
        return al != this.size;
    }
}

