/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.CompoundIntIterator;
import com.ibm.wala.util.collections.EmptyIntIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OffsetBitVector;

public class SemiSparseMutableIntSet
implements MutableIntSet {
    private static final boolean DEBUG = true;
    private static final double FIX_SPARSE_MOD = 12.0;
    private static final double FIX_SPARSE_RATIO = 0.05;
    private MutableSparseIntSet sparsePart;
    private OffsetBitVector densePart = null;

    public SemiSparseMutableIntSet() {
        this(MutableSparseIntSet.makeEmpty());
    }

    private SemiSparseMutableIntSet(MutableSparseIntSet sparsePart) {
        this.sparsePart = sparsePart;
    }

    private SemiSparseMutableIntSet(MutableSparseIntSet sparsePart, OffsetBitVector densePart) {
        this.sparsePart = sparsePart;
        this.densePart = densePart;
    }

    public SemiSparseMutableIntSet(SemiSparseMutableIntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        this.copySet(set);
    }

    private final boolean assertDisjoint() {
        if (this.densePart != null) {
            IntIterator sparseBits = this.sparsePart.intIterator();
            while (sparseBits.hasNext()) {
                int bit = sparseBits.next();
                if (this.densePart.contains(bit)) {
                    return false;
                }
                if (!this.inDenseRange(bit)) continue;
                return false;
            }
        }
        return true;
    }

    private void fixAfterSparseInsert() {
        if ((double)this.sparsePart.size() % 12.0 == 11.0 && (this.densePart == null || this.densePart != null && (double)this.sparsePart.size() > 0.05 * (double)this.densePart.getSize())) {
            assert (this.assertDisjoint()) : this.toString();
            if (this.densePart == null) {
                IntIterator sparseBits = this.sparsePart.intIterator();
                int maxOffset = -1;
                int maxCount = -1;
                int maxMax = -1;
                int offset = 0;
                int bits = 0;
                int count = 0;
                int oldBit = 0;
                while (sparseBits.hasNext()) {
                    int newCount;
                    int nextBit = sparseBits.next();
                    int newBits = bits + (nextBit - oldBit);
                    if (newBits < 32 * (newCount = count + 1)) {
                        count = newCount;
                        bits = newBits;
                        if (count > maxCount) {
                            maxOffset = offset;
                            maxMax = nextBit;
                            maxCount = count;
                        }
                    } else {
                        offset = nextBit;
                        count = 1;
                        bits = 32;
                    }
                    oldBit = nextBit;
                }
                if (maxOffset != -1) {
                    int bit;
                    this.densePart = new OffsetBitVector(maxOffset, maxMax - maxOffset);
                    sparseBits = this.sparsePart.intIterator();
                    while ((bit = sparseBits.next()) < maxOffset) {
                    }
                    this.densePart.set(bit);
                    int i = 1;
                    while (i < maxCount) {
                        this.densePart.set(sparseBits.next());
                        ++i;
                    }
                    this.sparsePart.removeAll(this.densePart);
                }
                assert (this.assertDisjoint()) : String.valueOf(this.toString()) + ", maxOffset=" + maxOffset + ", maxMax=" + maxMax + ", maxCount=" + maxCount;
            } else {
                IntIterator sparseBits = this.sparsePart.intIterator();
                int thisBit = sparseBits.next();
                int moveCount = 0;
                int newOffset = -1;
                int newCount = -1;
                int newLength = -1;
                if (thisBit < this.densePart.getOffset()) {
                    newOffset = thisBit;
                    int bits = 32;
                    int count = 1;
                    while (sparseBits.hasNext()) {
                        int nextBit = sparseBits.next();
                        if (nextBit >= this.densePart.getOffset() || !sparseBits.hasNext()) {
                            if (nextBit < this.densePart.getOffset() && !sparseBits.hasNext()) {
                                ++count;
                            }
                            if (this.densePart.getOffset() - newOffset < 32 * count) {
                                moveCount += count;
                            } else {
                                newOffset = -1;
                            }
                            thisBit = nextBit;
                            break;
                        }
                        if ((bits += nextBit - thisBit) > 32 * ++count) {
                            newOffset = nextBit;
                            count = 1;
                            bits = 32;
                        }
                        thisBit = nextBit;
                    }
                }
                while (thisBit < this.densePart.length() && sparseBits.hasNext()) {
                    thisBit = sparseBits.next();
                }
                if (thisBit >= this.densePart.length()) {
                    int count = 1;
                    int bits = thisBit + 1 - this.densePart.length();
                    if (32 * count > bits) {
                        newLength = thisBit;
                        newCount = 1;
                    }
                    while (sparseBits.hasNext()) {
                        thisBit = sparseBits.next();
                        bits = thisBit + 1 - this.densePart.length();
                        if (32 * ++count <= bits) continue;
                        newLength = thisBit;
                        newCount = count;
                    }
                    if (newLength > -1) {
                        moveCount += newCount;
                    }
                }
                if (moveCount > 0) {
                    int index = 0;
                    int[] bits = new int[moveCount];
                    sparseBits = this.sparsePart.intIterator();
                    while (sparseBits.hasNext()) {
                        int bit = sparseBits.next();
                        if (newOffset != -1 && bit >= newOffset && bit < this.densePart.getOffset()) {
                            bits[index++] = bit;
                        }
                        if (newLength == -1 || bit < this.densePart.length() || bit > newLength) continue;
                        bits[index++] = bit;
                    }
                    if (index != moveCount) {
                        Assertions._assert(index == moveCount, "index is " + index + ", but moveCount is " + moveCount + " for " + this);
                    }
                    if (newLength != -1 && bits[index - 1] == this.sparsePart.max()) {
                        int base = this.densePart.getOffset();
                        int currentSize = this.densePart.length() - base;
                        float newSize = 1.1f * (float)(bits[index - 1] - base);
                        float fraction = newSize / (float)currentSize;
                        assert (fraction > 1.0f);
                        this.densePart.growCapacity(fraction);
                    }
                    int i = index - 1;
                    while (i >= 0) {
                        this.sparsePart.remove(bits[i]);
                        this.densePart.set(bits[i]);
                        --i;
                    }
                }
                assert (this.assertDisjoint()) : String.valueOf(this.toString()) + ", densePart.length()=" + this.densePart.length() + ", newOffset=" + newOffset + ", newLength=" + newLength + ", newCount=" + newCount + ", moveCount=" + moveCount;
            }
        }
    }

    public boolean contains(int i) {
        if (this.densePart != null && this.inDenseRange(i)) {
            return this.densePart.contains(i);
        }
        return this.sparsePart.contains(i);
    }

    public boolean containsAny(IntSet set) {
        if (!this.sparsePart.isEmpty() && this.sparsePart.containsAny(set)) {
            return true;
        }
        if (this.densePart != null) {
            int lower = this.densePart.getOffset();
            IntIterator is = set.intIterator();
            while (is.hasNext()) {
                int i = is.next();
                if (i < lower || !this.densePart.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    public IntSet intersection(IntSet that) {
        SemiSparseMutableIntSet newThis = new SemiSparseMutableIntSet();
        IntIterator bits = this.intIterator();
        while (bits.hasNext()) {
            int bit = bits.next();
            if (!that.contains(bit)) continue;
            newThis.add(bit);
        }
        return newThis;
    }

    public IntSet union(IntSet that) {
        SemiSparseMutableIntSet temp = new SemiSparseMutableIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    public boolean isEmpty() {
        return this.sparsePart.isEmpty() && (this.densePart == null || this.densePart.isZero());
    }

    public int size() {
        return this.sparsePart.size() + (this.densePart == null ? 0 : this.densePart.populationCount());
    }

    public IntIterator intIterator() {
        class DensePartIterator
        implements IntIterator {
            private int i = -1;

            DensePartIterator() {
            }

            public boolean hasNext() {
                return SemiSparseMutableIntSet.this.densePart.nextSetBit(this.i + 1) != -1;
            }

            public int next() {
                int next;
                this.i = next = SemiSparseMutableIntSet.this.densePart.nextSetBit(this.i + 1);
                return next;
            }
        }
        if (this.sparsePart.isEmpty()) {
            if (this.densePart == null || this.densePart.isZero()) {
                return EmptyIntIterator.instance();
            }
            return new DensePartIterator();
        }
        if (this.densePart == null || this.densePart.isZero()) {
            return this.sparsePart.intIterator();
        }
        return new CompoundIntIterator(this.sparsePart.intIterator(), new DensePartIterator());
    }

    public void foreach(IntSetAction action) {
        this.sparsePart.foreach(action);
        if (this.densePart != null) {
            int b = this.densePart.nextSetBit(0);
            while (b != -1) {
                action.act(b);
                b = this.densePart.nextSetBit(b + 1);
            }
        }
    }

    public void foreachExcluding(IntSet X, IntSetAction action) {
        this.sparsePart.foreachExcluding(X, action);
        if (this.densePart != null) {
            int b = this.densePart.nextSetBit(0);
            while (b != -1) {
                if (!X.contains(b)) {
                    action.act(b);
                }
                b = this.densePart.nextSetBit(b + 1);
            }
        }
    }

    public int max() throws IllegalStateException {
        if (this.densePart == null) {
            return this.sparsePart.max();
        }
        return Math.max(this.sparsePart.max(), this.densePart.max());
    }

    public boolean sameValue(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("that is null");
        }
        if (this.size() != that.size()) {
            return false;
        }
        if (this.densePart != null) {
            int bit = this.densePart.nextSetBit(0);
            while (bit != -1) {
                if (!that.contains(bit)) {
                    return false;
                }
                bit = this.densePart.nextSetBit(bit + 1);
            }
        }
        IntIterator bits = this.sparsePart.intIterator();
        while (bits.hasNext()) {
            if (that.contains(bits.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isSubset(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("that is null");
        }
        if (this.size() > that.size()) {
            return false;
        }
        IntIterator bits = this.sparsePart.intIterator();
        while (bits.hasNext()) {
            if (that.contains(bits.next())) continue;
            return false;
        }
        if (this.densePart != null) {
            int b = this.densePart.nextSetBit(0);
            while (b != -1) {
                if (!that.contains(b)) {
                    return false;
                }
                b = this.densePart.nextSetBit(b + 1);
            }
        }
        return true;
    }

    public void copySet(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof SemiSparseMutableIntSet) {
            SemiSparseMutableIntSet that = (SemiSparseMutableIntSet)set;
            this.sparsePart = MutableSparseIntSet.make(that.sparsePart);
            this.densePart = that.densePart == null ? null : new OffsetBitVector(that.densePart);
        } else {
            this.densePart = null;
            this.sparsePart = MutableSparseIntSet.makeEmpty();
            IntIterator bits = set.intIterator();
            while (bits.hasNext()) {
                this.add(bits.next());
            }
        }
    }

    private boolean inDenseRange(int i) {
        return this.densePart.getOffset() <= i && this.densePart.length() > i;
    }

    public boolean addAll(IntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        boolean change = false;
        if (set instanceof SemiSparseMutableIntSet) {
            SemiSparseMutableIntSet that = (SemiSparseMutableIntSet)set;
            if (this.densePart == null) {
                if (that.densePart != null) {
                    int oldSize = this.size();
                    this.densePart = new OffsetBitVector(that.densePart);
                    IntIterator bits = this.sparsePart.intIterator();
                    while (bits.hasNext()) {
                        int bit = bits.next();
                        if (!this.inDenseRange(bit)) continue;
                        this.densePart.set(bit);
                    }
                    this.sparsePart.removeAll(this.densePart);
                    this.sparsePart.addAll(that.sparsePart);
                    change = this.size() != oldSize;
                } else {
                    change = this.sparsePart.addAll(that.sparsePart);
                    this.fixAfterSparseInsert();
                }
            } else if (that.densePart != null) {
                int oldSize = this.size();
                this.densePart.or(that.densePart);
                this.sparsePart.addAll(that.sparsePart);
                IntIterator bits = this.sparsePart.intIterator();
                while (bits.hasNext()) {
                    int bit = bits.next();
                    if (!this.inDenseRange(bit)) continue;
                    this.densePart.set(bit);
                }
                this.sparsePart.removeAll(this.densePart);
                change = this.size() != oldSize;
            } else {
                IntIterator bs = that.sparsePart.intIterator();
                while (bs.hasNext()) {
                    change |= this.add(bs.next());
                }
            }
        } else {
            IntIterator bs = set.intIterator();
            while (bs.hasNext()) {
                change |= this.add(bs.next());
            }
        }
        assert (this.assertDisjoint()) : this.toString();
        return change;
    }

    public boolean add(int i) {
        if (this.densePart != null && this.inDenseRange(i)) {
            if (!this.densePart.get(i)) {
                this.densePart.set(i);
                assert (this.assertDisjoint()) : this.toString();
                return true;
            }
        } else if (!this.sparsePart.contains(i)) {
            this.sparsePart.add(i);
            assert (this.assertDisjoint()) : this.toString();
            this.fixAfterSparseInsert();
            return true;
        }
        return false;
    }

    public boolean remove(int i) {
        if (this.densePart != null && this.densePart.get(i)) {
            this.densePart.clear(i);
            if (this.densePart.nextSetBit(0) == -1) {
                this.densePart = null;
            }
            return true;
        }
        if (this.sparsePart.contains(i)) {
            this.sparsePart.remove(i);
            return true;
        }
        return false;
    }

    public void intersectWith(IntSet set) {
        this.sparsePart.intersectWith(set);
        if (this.densePart != null) {
            int b = this.densePart.nextSetBit(0);
            while (b != -1) {
                if (!set.contains(b)) {
                    this.densePart.clear(b);
                }
                b = this.densePart.nextSetBit(b + 1);
            }
        }
    }

    public boolean addAllInIntersection(IntSet other, IntSet filter) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        boolean change = false;
        IntIterator bits = other.intIterator();
        while (bits.hasNext()) {
            int bit = bits.next();
            if (!filter.contains(bit)) continue;
            change |= this.add(bit);
        }
        return change;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        if (this.densePart != null) {
            sb.append("densePart: ").append(this.densePart.toString()).append(" ");
        }
        sb.append("sparsePart: ").append(this.sparsePart.toString()).append("]");
        return sb.toString();
    }

    public SemiSparseMutableIntSet removeAll(SemiSparseMutableIntSet B) {
        if (this.densePart == null) {
            if (B.densePart == null) {
                this.sparsePart = MutableSparseIntSet.diff(this.sparsePart, B.sparsePart);
            } else {
                MutableSparseIntSet C = MutableSparseIntSet.diff(this.sparsePart, B.sparsePart);
                IntIterator bits = this.sparsePart.intIterator();
                while (bits.hasNext()) {
                    int bit = bits.next();
                    if (!B.densePart.get(bit)) continue;
                    C.remove(bit);
                }
                this.sparsePart = C;
            }
        } else if (B.densePart == null) {
            IntIterator bits = B.sparsePart.intIterator();
            while (bits.hasNext()) {
                this.densePart.clear(bits.next());
            }
            this.sparsePart = MutableSparseIntSet.diff(this.sparsePart, B.sparsePart);
        } else {
            this.densePart.andNot(B.densePart);
            IntIterator bits = B.sparsePart.intIterator();
            while (bits.hasNext()) {
                this.densePart.clear(bits.next());
            }
            MutableSparseIntSet C = MutableSparseIntSet.diff(this.sparsePart, B.sparsePart);
            IntIterator bits2 = this.sparsePart.intIterator();
            while (bits2.hasNext()) {
                int bit = bits2.next();
                if (!B.densePart.get(bit)) continue;
                C.remove(bit);
            }
            this.sparsePart = C;
        }
        return this;
    }

    public static SemiSparseMutableIntSet diff(SemiSparseMutableIntSet A, SemiSparseMutableIntSet B) {
        if (A == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (A.densePart == null) {
            if (B.densePart == null) {
                return new SemiSparseMutableIntSet(MutableSparseIntSet.diff(A.sparsePart, B.sparsePart));
            }
            MutableSparseIntSet C = MutableSparseIntSet.diff(A.sparsePart, B.sparsePart);
            IntIterator bits = A.sparsePart.intIterator();
            while (bits.hasNext()) {
                int bit = bits.next();
                if (!B.densePart.get(bit)) continue;
                C.remove(bit);
            }
            return new SemiSparseMutableIntSet(C);
        }
        if (B.densePart == null) {
            OffsetBitVector newDensePart = new OffsetBitVector(A.densePart);
            IntIterator bits = B.sparsePart.intIterator();
            while (bits.hasNext()) {
                newDensePart.clear(bits.next());
            }
            return new SemiSparseMutableIntSet(MutableSparseIntSet.diff(A.sparsePart, B.sparsePart), newDensePart);
        }
        OffsetBitVector newDensePart = new OffsetBitVector(A.densePart);
        newDensePart.andNot(B.densePart);
        IntIterator bits = B.sparsePart.intIterator();
        while (bits.hasNext()) {
            newDensePart.clear(bits.next());
        }
        MutableSparseIntSet C = MutableSparseIntSet.diff(A.sparsePart, B.sparsePart);
        IntIterator bits2 = A.sparsePart.intIterator();
        while (bits2.hasNext()) {
            int bit = bits2.next();
            if (!B.densePart.get(bit)) continue;
            C.remove(bit);
        }
        return new SemiSparseMutableIntSet(C, newDensePart);
    }
}

