/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

public class SemiSparseMutableIntSetFactory
implements MutableIntSetFactory {
    public MutableIntSet make(int[] set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (set.length == 0) {
            return new BitVectorIntSet();
        }
        TreeSet<Integer> T = new TreeSet<Integer>();
        int i = 0;
        while (i < set.length) {
            T.add(new Integer(set[i]));
            ++i;
        }
        SemiSparseMutableIntSet result = new SemiSparseMutableIntSet();
        for (Integer I : T) {
            result.add(I);
        }
        return result;
    }

    public MutableIntSet parse(String string) throws NumberFormatException {
        int[] data = SparseIntSet.parseIntArray(string);
        SemiSparseMutableIntSet result = new SemiSparseMutableIntSet();
        int i = 0;
        while (i < data.length) {
            result.add(data[i]);
            ++i;
        }
        return result;
    }

    public MutableIntSet makeCopy(IntSet x) {
        SemiSparseMutableIntSet y = new SemiSparseMutableIntSet();
        y.copySet(x);
        return y;
    }

    public MutableIntSet make() {
        return new SemiSparseMutableIntSet();
    }
}

