/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.intset.IntVector;
import java.util.Arrays;

public class SimpleIntVector
implements IntVector {
    private static final float GROWTH_FACTOR = 1.5f;
    private static final int INITIAL_SIZE = 1;
    int maxIndex = -1;
    int[] store;
    final int defaultValue;

    public SimpleIntVector(int defaultValue) {
        this.defaultValue = defaultValue;
        this.store = new int[this.getInitialSize()];
        this.store[0] = defaultValue;
    }

    public SimpleIntVector(int defaultValue, int initialSize) {
        this.defaultValue = defaultValue;
        this.store = new int[initialSize];
        this.store[0] = defaultValue;
    }

    int getInitialSize() {
        return 1;
    }

    float getGrowthFactor() {
        return 1.5f;
    }

    public int get(int x) {
        Assertions._assert(x >= 0);
        if (x < this.store.length) {
            return this.store[x];
        }
        return this.defaultValue;
    }

    public void set(int x, int value) {
        Assertions._assert(x >= 0);
        this.maxIndex = Math.max(this.maxIndex, x);
        if (value == this.defaultValue) {
            if (x >= this.store.length) {
                return;
            }
            this.store[x] = value;
        } else {
            this.ensureCapacity(x);
            this.store[x] = value;
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.store.length) {
            int[] old = this.store;
            this.store = new int[1 + (int)(this.getGrowthFactor() * (float)capacity)];
            Arrays.fill(this.store, this.defaultValue);
            System.arraycopy(old, 0, this.store, 0, old.length);
        }
    }

    public void performVerboseAction() {
        Trace.println("size:       " + this.store.length);
        Trace.println("occupancy:  " + this.computeOccupancy());
    }

    private double computeOccupancy() {
        int count1 = 0;
        int i = 0;
        while (i < this.store.length) {
            if (this.store[i] != -1) {
                ++count1;
            }
            ++i;
        }
        int count = count1;
        return (double)count / (double)this.store.length;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }
}

