/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.intset.IVector;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVector<T>
implements IVector<T> {
    private static final double GROWTH_FACTOR = 1.5;
    Object[] store = new Object[1];
    int maxIndex = -1;

    @Override
    public T get(int x) {
        Assertions._assert(x >= 0);
        if (x < this.store.length) {
            return (T)this.store[x];
        }
        return null;
    }

    @Override
    public void set(int x, T value) {
        Assertions._assert(x >= 0);
        this.maxIndex = Math.max(this.maxIndex, x);
        if (value == null) {
            if (x >= this.store.length) {
                return;
            }
            this.store[x] = value;
        } else {
            this.ensureCapacity(x);
            this.store[x] = value;
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.store.length) {
            Object[] old = this.store;
            this.store = new Object[1 + (int)(1.5 * (double)capacity)];
            System.arraycopy(old, 0, this.store, 0, old.length);
        }
    }

    @Override
    public void performVerboseAction() {
        Trace.println("size:       " + this.store.length);
        Trace.println("occupancy:  " + this.computeOccupancy());
    }

    private double computeOccupancy() {
        int count = 0;
        int i = 0;
        while (i < this.store.length) {
            if (this.store[i] != null) {
                ++count;
            }
            ++i;
        }
        return (double)count / (double)this.store.length;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i <= this.maxIndex) {
            result.add(this.store[i]);
            ++i;
        }
        return result.iterator();
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }
}

