/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SparseIntSet
implements IntSet {
    private static final int SINGLETON_CACHE_SIZE = 5000;
    private static final SparseIntSet[] singletonCache = new SparseIntSet[5000];
    protected int[] elements;
    protected int size = 0;

    static {
        int i = 0;
        while (i < 5000) {
            SparseIntSet.singletonCache[i] = new SparseIntSet(new int[]{i});
            ++i;
        }
    }

    protected SparseIntSet(int size) {
        this.elements = new int[size];
        this.size = size;
    }

    protected SparseIntSet(int[] backingArray) {
        if (backingArray == null) {
            throw new IllegalArgumentException("backingArray is null");
        }
        this.elements = backingArray;
        this.size = backingArray.length;
    }

    public SparseIntSet() {
        this.elements = null;
        this.size = 0;
    }

    protected SparseIntSet(SparseIntSet S) {
        this.cloneState(S);
    }

    private void cloneState(SparseIntSet S) {
        this.elements = (int[])(S.elements != null ? (int[])S.elements.clone() : null);
        this.size = S.size;
    }

    public SparseIntSet(IntSet S) throws IllegalArgumentException {
        if (S == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (S instanceof SparseIntSet) {
            this.cloneState((SparseIntSet)S);
        } else {
            this.elements = new int[S.size()];
            this.size = S.size();
            S.foreach(new IntSetAction(){
                private int index = 0;

                public void act(int i) {
                    SparseIntSet.this.elements[this.index++] = i;
                }
            });
        }
    }

    public final boolean contains(int x) {
        if (this.elements == null) {
            return false;
        }
        return IntSetUtil.binarySearch(this.elements, x, 0, this.size - 1) >= 0;
    }

    public final int getIndex(int x) {
        if (this.elements == null) {
            return -1;
        }
        return IntSetUtil.binarySearch(this.elements, x, 0, this.size - 1);
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int elementAt(int idx) throws NoSuchElementException {
        if (this.elements == null || idx >= this.size) {
            throw new NoSuchElementException("Index: " + idx);
        }
        return this.elements[idx];
    }

    private boolean sameValueInternal(SparseIntSet that) {
        if (this.size != that.size) {
            return false;
        }
        int i = 0;
        while (i < this.size) {
            if (this.elements[i] != that.elements[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean sameValue(IntSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseIntSet) {
            return this.sameValueInternal((SparseIntSet)that);
        }
        if (that instanceof BimodalMutableIntSet) {
            return that.sameValue(this);
        }
        if (that instanceof BitVectorIntSet) {
            return that.sameValue(this);
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue(((MutableSharedBitVectorIntSet)that).makeSparseCopy());
        }
        Assertions.UNREACHABLE(that.getClass().toString());
        return false;
    }

    private boolean isSubsetInternal(SparseIntSet that) {
        if (this.elements == null) {
            return true;
        }
        if (that.elements == null) {
            return false;
        }
        if (this.equals(that)) {
            return true;
        }
        if (this.sameValue(that)) {
            return true;
        }
        int[] ar = this.elements;
        int ai = 0;
        int al = this.size;
        int[] br = that.elements;
        int bi = 0;
        int bl = that.size;
        while (ai < al && bi < bl) {
            int cmp = ar[ai] - br[bi];
            if (cmp > 0) {
                ++bi;
                continue;
            }
            if (cmp < 0) {
                return false;
            }
            ++ai;
            ++bi;
        }
        return bi != bl || ai >= al;
    }

    public static SparseIntSet diff(SparseIntSet A, SparseIntSet B) {
        return new SparseIntSet(SparseIntSet.diffInternal(A, B));
    }

    public static int[] diffInternal(SparseIntSet A, SparseIntSet B) {
        if (A == null) {
            throw new IllegalArgumentException("A is null");
        }
        Assertions._assert(B != null);
        if (A.isEmpty()) {
            return new int[0];
        }
        if (B.isEmpty()) {
            int[] newElts = new int[A.size];
            System.arraycopy(A.elements, 0, newElts, 0, A.size);
            return newElts;
        }
        if (A.equals(B)) {
            return new int[0];
        }
        if (A.sameValue(B)) {
            return new int[0];
        }
        int[] ar = A.elements;
        int ai = 0;
        int al = A.size;
        int[] br = B.elements;
        int bi = 0;
        int bl = B.size;
        int[] cr = new int[al];
        int ci = 0;
        while (ai < al && bi < bl) {
            int cmp = ar[ai] - br[bi];
            if (cmp > 0) {
                ++bi;
                continue;
            }
            if (cmp < 0) {
                cr[ci++] = ar[ai];
                ++ai;
                continue;
            }
            ++ai;
            ++bi;
        }
        if (ai < al) {
            int tail = al - ai;
            System.arraycopy(ar, ai, cr, ci, tail);
            ci += tail;
        }
        ar = new int[ci];
        System.arraycopy(cr, 0, ar, 0, ci);
        return ar;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(6 * this.size);
        sb.append("{ ");
        if (this.elements != null) {
            int ii = 0;
            while (ii < this.size) {
                sb.append(this.elements[ii]);
                sb.append(" ");
                ++ii;
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static int[] parseIntArray(String str) throws NumberFormatException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        int len = str.length();
        if (len == 0 || str.charAt(0) != '{' || str.charAt(len - 1) != '}') {
            throw new NumberFormatException(str);
        }
        str = str.substring(1, len - 1);
        StringTokenizer tok = new StringTokenizer(str, " ,");
        TreeSet<Integer> set = new TreeSet<Integer>();
        while (tok.hasMoreTokens()) {
            set.add(Integer.decode(tok.nextToken()));
        }
        int[] result = new int[set.size()];
        int i = 0;
        for (Integer I : set) {
            result[i++] = I;
        }
        return result;
    }

    public static SparseIntSet singleton(int i) {
        if (i >= 0 && i < 5000) {
            return singletonCache[i];
        }
        return new SparseIntSet(new int[]{i});
    }

    public static SparseIntSet pair(int i, int j) {
        if (i == j) {
            return SparseIntSet.singleton(i);
        }
        if (j > i) {
            return new SparseIntSet(new int[]{i, j});
        }
        return new SparseIntSet(new int[]{j, i});
    }

    public IntSet intersection(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseIntSet) {
            MutableSparseIntSet temp = MutableSparseIntSet.make(this);
            temp.intersectWith((SparseIntSet)that);
            return temp;
        }
        if (that instanceof BitVectorIntSet) {
            SparseIntSet s = ((BitVectorIntSet)that).toSparseIntSet();
            MutableSparseIntSet temp = MutableSparseIntSet.make(this);
            temp.intersectWith(s);
            return temp;
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            MutableSparseIntSet temp = MutableSparseIntSet.make(this);
            temp.intersectWith(that);
            return temp;
        }
        MutableSparseIntSet temp = MutableSparseIntSet.makeEmpty();
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            int x = it.next();
            if (!that.contains(x)) continue;
            temp.add(x);
        }
        return temp;
    }

    public IntSet union(IntSet that) {
        MutableSparseIntSet temp = new MutableSparseIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < SparseIntSet.this.size;
            }

            public int next() throws NoSuchElementException {
                if (SparseIntSet.this.elements == null) {
                    throw new NoSuchElementException();
                }
                return SparseIntSet.this.elements[this.i++];
            }
        };
    }

    public final int max() throws IllegalStateException {
        if (this.elements == null) {
            throw new IllegalStateException("Illegal to ask max() on an empty int set");
        }
        return this.elements[this.size - 1];
    }

    public void foreach(IntSetAction action) {
        int i = 0;
        while (i < this.size) {
            action.act(this.elements[i]);
            ++i;
        }
    }

    public void foreachExcluding(IntSet X, IntSetAction action) {
        int i = 0;
        while (i < this.size) {
            if (!X.contains(this.elements[i])) {
                action.act(this.elements[i]);
            }
            ++i;
        }
    }

    public static SparseIntSet add(SparseIntSet s, int j) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.elements == null) {
            return SparseIntSet.singleton(j);
        }
        SparseIntSet result = new SparseIntSet(s.size + 1);
        int k = 0;
        int m = 0;
        while (k < s.elements.length && s.elements[k] < j) {
            result.elements[k++] = s.elements[m++];
        }
        if (k == s.size) {
            result.elements[k] = j;
        } else {
            if (s.elements[k] == j) {
                --result.size;
            } else {
                result.elements[k++] = j;
            }
            while (k < result.size) {
                result.elements[k++] = s.elements[m++];
            }
        }
        return result;
    }

    public boolean isSubset(IntSet that) {
        if (that instanceof SparseIntSet) {
            return this.isSubsetInternal((SparseIntSet)that);
        }
        if (that instanceof BitVectorIntSet) {
            return this.isSubsetInternal((BitVectorIntSet)that);
        }
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            if (that.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSubsetInternal(BitVectorIntSet set) {
        int i = 0;
        while (i < this.size) {
            if (!set.contains(this.elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsAny(IntSet set) {
        if (set instanceof SparseIntSet) {
            return this.containsAny((SparseIntSet)set);
        }
        if (set instanceof BimodalMutableIntSet) {
            return set.containsAny(this);
        }
        int i = 0;
        while (i < this.size) {
            if (set.contains(this.elements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAny(SparseIntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        int i = 0;
        int j = 0;
        while (j < set.size) {
            int x = set.elements[j];
            while (i < this.size && this.elements[i] < x) {
                ++i;
            }
            if (i == this.size) {
                return false;
            }
            if (this.elements[i] == x) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size];
        if (this.size > 0) {
            System.arraycopy(this.elements, 0, result, 0, this.size);
        }
        return result;
    }
}

