/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.intset.MutableSparseLongSet;

public class SparseLongIntVector {
    private static final int INITIAL_SIZE = 5;
    private final double EXPANSION = 1.5;
    private final MutableSparseLongSet indices = new MutableSparseLongSet();
    private int[] data = new int[5];
    private final int defaultValue;

    public SparseLongIntVector(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int get(long x) {
        int index = this.indices.getIndex(x);
        if (index == -1) {
            return this.defaultValue;
        }
        return this.data[index];
    }

    public void set(long x, int value) {
        int index = this.indices.getIndex(x);
        if (index == -1) {
            this.indices.add(x);
            index = this.indices.getIndex(x);
            this.ensureCapacity(this.indices.size() + 1);
            if (index < this.data.length - 1) {
                System.arraycopy(this.data, index, this.data, index + 1, this.indices.size() - index);
            }
        }
        this.data[index] = value;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length < capacity + 1) {
            int[] old = this.data;
            this.data = new int[1 + (int)((double)capacity * 1.5)];
            System.arraycopy(old, 0, this.data, 0, old.length);
        }
    }

    public void performVerboseAction() {
        Trace.println(this.getClass() + " stats: ");
        Trace.println("data.length " + this.data.length);
        Trace.println("indices.size() " + this.indices.size());
    }
}

