/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.intset.IVector;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.TunedMutableSparseIntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseVector<T>
implements IVector<T> {
    private static final int DEF_INITIAL_SIZE = 5;
    private MutableSparseIntSet indices = MutableSparseIntSet.makeEmpty();
    private Object[] data = new Object[5];

    public SparseVector() {
        this.indices = MutableSparseIntSet.makeEmpty();
    }

    public SparseVector(int initialSize, float expansion) {
        this.indices = new TunedMutableSparseIntSet(initialSize, expansion);
    }

    @Override
    public T get(int x) {
        int index = this.indices.getIndex(x);
        if (index == -1) {
            return null;
        }
        return (T)this.data[index];
    }

    @Override
    public void set(int x, T value) {
        int index = this.indices.getIndex(x);
        if (index == -1) {
            this.indices.add(x);
            index = this.indices.getIndex(x);
            this.ensureCapacity(this.indices.size() + 1);
            if (index < this.data.length - 1) {
                System.arraycopy(this.data, index, this.data, index + 1, this.indices.size() - index);
            }
        }
        this.data[index] = value;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length < capacity + 1) {
            Object[] old = this.data;
            this.data = new Object[1 + (int)((float)capacity * this.indices.getExpansionFactor())];
            System.arraycopy(old, 0, this.data, 0, old.length);
        }
    }

    @Override
    public void performVerboseAction() {
        Trace.println(this.getClass() + " stats: ");
        Trace.println("data.length " + this.data.length);
        Trace.println("indices.size() " + this.indices.size());
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseVector.this.indices.size();
            }

            @Override
            public T next() {
                return SparseVector.this.data[this.i++];
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getMaxIndex() throws IllegalStateException {
        return this.indices.max();
    }

    public int size() {
        return this.indices.size();
    }

    public IntIterator iterateIndices() {
        return this.indices.intIterator();
    }

    public IntIterator safeIterateIndices() {
        return MutableSparseIntSet.make(this.indices).intIterator();
    }

    public void clear() {
        this.data = new Object[5];
        this.indices = MutableSparseIntSet.makeEmpty();
    }

    public void remove(int x) {
        int index = this.indices.getIndex(x);
        if (index == -1) {
            return;
        }
        System.arraycopy(this.data, index + 1, this.data, index, this.size() - index - 1);
        this.indices.remove(x);
    }
}

