/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

public class FileSuffixes {
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private static final String WAR_SUFFIX = ".war";
    private static final String CLASSPATH = ".classpath";

    public static boolean isClassFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        int suffixIndex = fileName.indexOf(CLASS_SUFFIX);
        return suffixIndex > -1 && fileName.indexOf(CLASSPATH) == -1;
    }

    public static boolean isSourceFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        int suffixIndex = fileName.indexOf(".java");
        return suffixIndex > -1 && fileName.indexOf(CLASSPATH) == -1;
    }

    public static boolean isJarFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        int suffixIndex = fileName.indexOf(JAR_SUFFIX);
        return suffixIndex > -1;
    }

    public static boolean isWarFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        int suffixIndex = fileName.indexOf(WAR_SUFFIX);
        return suffixIndex > -1;
    }

    public static String stripSuffix(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        int suffixIndex = fileName.indexOf(CLASS_SUFFIX);
        int n = suffixIndex = suffixIndex > -1 ? suffixIndex : fileName.indexOf(".java");
        if (suffixIndex > -1) {
            return fileName.substring(0, suffixIndex);
        }
        return fileName;
    }
}

