/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.warnings.WalaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static Collection<File> listFiles(String dir, String regex, boolean recurse) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is null");
        }
        File d = new File(dir);
        Pattern p = null;
        if (regex != null) {
            p = Pattern.compile(regex);
        }
        return FileUtil.listFiles(d, recurse, p);
    }

    private static Collection<File> listFiles(File directory, boolean recurse, Pattern p) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        HashSet<File> result = HashSetFactory.make();
        int i = 0;
        while (i < files.length) {
            if (p == null || p.matcher(files[i].getAbsolutePath()).matches()) {
                result.add(files[i]);
            }
            if (recurse && files[i].isDirectory()) {
                result.addAll(FileUtil.listFiles(files[i], recurse, p));
            }
            ++i;
        }
        return result;
    }

    public static void copy(String srcFileName, String destFileName) throws WalaException {
        FileChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            try {
                src = new FileInputStream(srcFileName).getChannel();
                dest = new FileOutputStream(destFileName).getChannel();
                long n = src.size();
                MappedByteBuffer buf = src.map(FileChannel.MapMode.READ_ONLY, 0L, n);
                ((FileChannel)dest).write(buf);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new WalaException("Failed to copy " + srcFileName + " to " + destFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new WalaException("Failed to copy " + srcFileName + " to " + destFileName);
            }
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
            if (src != null) {
                try {
                    src.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteContents(String directory) throws IOException {
        Collection<File> fl = FileUtil.listFiles(directory, null, true);
        for (File f : fl) {
            boolean result;
            if (f.isDirectory() || (result = f.delete())) continue;
            throw new IOException("Failed to delete " + f);
        }
        int lastCount = Integer.MAX_VALUE;
        do {
            Collection<File> f2;
            if ((f2 = FileUtil.listFiles(directory, null, true)).size() == lastCount) {
                throw new IOException("got stuck deleting directories. Probably some other process is preventing deletion.");
            }
            lastCount = f2.size();
            for (File f : f2) {
                f.delete();
            }
        } while (FileUtil.listFiles(directory, null, true).size() > 0);
    }
}

