/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.scope;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.util.collections.Filter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageExpressionFilter
implements Filter<IClass> {
    private final Pattern pattern;

    public PackageExpressionFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean accepts(IClass c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        if (c.getName().getPackage() == null) {
            return false;
        }
        String packageName = c.getName().getPackage().toString();
        Matcher m = this.pattern.matcher(packageName);
        return m.matches();
    }

    public String toString() {
        return "PackageExpressionFilter:" + this.pattern.pattern();
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

