/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.config.FileProvider;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.SimpleVector;
import com.ibm.wala.util.tables.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTable
extends Table<String>
implements Cloneable {
    public StringTable() {
    }

    public StringTable(StringTable t) {
        super(t);
    }

    public StringTable(String[] columns) {
        super(columns);
    }

    public static StringTable readFromDirectTextFile(String fileName) throws FileNotFoundException, IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        File f = new File(fileName);
        return StringTable.readFromTextFile(f);
    }

    public static StringTable readFromTextFile(String fileName) throws IOException {
        File f = FileProvider.getFile(fileName);
        return StringTable.readFromTextFile(f);
    }

    public static StringTable readFromTextFile(File f) throws FileNotFoundException, IOException {
        return StringTable.readFromStream(new FileInputStream(f));
    }

    public static StringTable readFromStream(InputStream s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        StringTable result = new StringTable();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(s));
        String line = StringTable.readNextNonCommentLine(reader);
        if (line == null) {
            throw new IOException("first line expected to be column headings");
        }
        result.populateColumnHeadings(line);
        line = StringTable.readNextNonCommentLine(reader);
        int row = 0;
        while (line != null) {
            result.populateRow(row, line);
            line = StringTable.readNextNonCommentLine(reader);
            ++row;
        }
        return result;
    }

    public static String readNextNonCommentLine(LineNumberReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        String line = reader.readLine();
        while (line != null && StringTable.isCommented(line)) {
            line = reader.readLine();
        }
        return line;
    }

    private static boolean isCommented(String line) {
        return line.charAt(0) == '#';
    }

    private void populateRow(int row, String line) {
        StringTokenizer st = new StringTokenizer(line);
        int nColumns = st.countTokens();
        Assertions.productionAssertion(nColumns == this.getNumberOfColumns(), "expected " + this.getNumberOfColumns() + " got " + nColumns + " row " + row);
        SimpleVector<String> r = new SimpleVector<String>();
        this.rows.add(row, r);
        int i = 0;
        while (i < nColumns) {
            r.set(i, (String)st.nextElement());
            ++i;
        }
    }

    private void populateColumnHeadings(String line) {
        StringTokenizer st = new StringTokenizer(line);
        int nColumns = st.countTokens();
        int i = 0;
        while (i < nColumns) {
            this.columnHeadings.set(i, (String)st.nextElement());
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        StringTable result = new StringTable(this);
        int i = 0;
        while (i < this.getNumberOfRows()) {
            result.addRow(this.row2Map(i));
            ++i;
        }
        return result;
    }
}

