/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.StringStuff;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.SimpleVector;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<T>
implements Cloneable {
    protected final ArrayList<SimpleVector<T>> rows = new ArrayList();
    protected final SimpleVector<String> columnHeadings = new SimpleVector();

    public Table() {
    }

    public Table(Table<T> t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        int i = 0;
        while (i < t.getNumberOfColumns()) {
            this.columnHeadings.set(i, t.getColumnHeading(i));
            ++i;
        }
    }

    public Table(String[] columns) throws IllegalArgumentException {
        if (columns == null) {
            throw new IllegalArgumentException("columns == null");
        }
        int i = 0;
        while (i < columns.length) {
            this.columnHeadings.set(i, columns[i]);
            ++i;
        }
    }

    public String toString() {
        int[] format = this.computeColumnWidths();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            StringBuffer heading = new StringBuffer(this.getColumnHeading(i));
            StringStuff.padWithSpaces(heading, format[i]);
            result.append(heading);
            ++i;
        }
        result.append("\n");
        int j = 0;
        while (j < this.getNumberOfRows()) {
            int i2 = 0;
            while (i2 < this.getNumberOfColumns()) {
                StringBuffer element = new StringBuffer(this.getElement(j, i2).toString());
                StringStuff.padWithSpaces(element, format[i2]);
                result.append(element);
                ++i2;
            }
            result.append("\n");
            ++j;
        }
        return result.toString();
    }

    public synchronized T getElement(int row, int column) {
        SimpleVector<T> r = this.rows.get(row);
        return r.get(column);
    }

    public synchronized String getColumnHeading(int i) {
        return this.columnHeadings.get(i);
    }

    private int[] computeColumnWidths() {
        int[] result = new int[this.getNumberOfColumns()];
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            result[i] = this.columnHeadings.get(i).toString().length() + 1;
            ++i;
        }
        int j = 0;
        while (j < this.getNumberOfRows()) {
            int i2 = 0;
            while (i2 < this.getNumberOfColumns()) {
                result[i2] = Math.max(result[i2], this.getElement(j, i2).toString().length() + 1);
                ++i2;
            }
            ++j;
        }
        return result;
    }

    public synchronized int getNumberOfColumns() {
        return this.columnHeadings.getMaxIndex() + 1;
    }

    public synchronized int getNumberOfRows() {
        return this.rows.size();
    }

    public synchronized Map<String, T> row2Map(int row) {
        Map result = HashMapFactory.make();
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            result.put(this.getColumnHeading(j), this.getElement(row, j));
            ++j;
        }
        return result;
    }

    public synchronized void addRow(Map<String, T> p) {
        SimpleVector<T> r = new SimpleVector<T>();
        this.rows.add(r);
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            r.set(i, p.get(this.getColumnHeading(i)));
            ++i;
        }
    }

    public synchronized void removeRow(Map<String, T> p) {
        BitVector toRemove = new BitVector();
        int i = 0;
        while (i < this.rows.size()) {
            Map<String, T> row = this.row2Map(i);
            if (row.equals(p)) {
                toRemove.set(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.rows.size()) {
            if (toRemove.get(i)) {
                this.rows.remove(i);
            }
            ++i;
        }
    }
}

