/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.warnings;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.util.warnings.MethodWarning;

public class ResolutionFailure
extends MethodWarning {
    final Object ref;
    final String message;

    public ResolutionFailure(CGNode node, Object ref, String message) throws NullPointerException {
        super((byte)2, node.getMethod().getReference());
        this.message = message;
        this.ref = ref;
    }

    private ResolutionFailure(CGNode node, Object ref) {
        this(node, ref, null);
    }

    public String getMsg() {
        if (this.message == null) {
            return this.getClass() + " " + this.getMethod() + " " + this.ref;
        }
        return this.getClass() + " " + this.getMethod() + ": " + this.message + " for " + this.ref;
    }

    public static ResolutionFailure create(CGNode node, Object ref) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        return ResolutionFailure.make(node, ref);
    }

    public static ResolutionFailure create(CGNode node, Object ref, String msg) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        return new ResolutionFailure(node, ref, msg);
    }

    public static ResolutionFailure make(CGNode node, Object ref) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return new ResolutionFailure(node, ref);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            ResolutionFailure other = (ResolutionFailure)obj;
            return this.getMethod().equals(other.getMethod()) && this.getLevel() == other.getLevel() && this.ref.equals(other.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.getMethod().hashCode() * 8999 + this.ref.hashCode() * 8461 + this.getLevel();
    }
}

