/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeDecorator;
import com.ibm.wala.util.warnings.WalaException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotUtil {
    private static final int MAX_LABEL_LENGTH = 75;

    public static <T> void dotify(Graph<T> g, NodeDecorator labels, String dotFile, String psFile, String dotExe) throws WalaException {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        File f = DotUtil.writeDotFile(g, labels, dotFile);
        DotUtil.spawnDot(dotExe, psFile, f);
    }

    public static void spawnDot(String dotExe, String psFile, File dotFile) throws WalaException {
        if (dotFile == null) {
            throw new IllegalArgumentException("dotFile is null");
        }
        Object[] cmdarray = new String[]{dotExe, "-Tps", "-o", psFile, "-v", dotFile.getAbsolutePath()};
        System.out.println("spawning process " + Arrays.toString(cmdarray));
        try {
            Process p = Runtime.getRuntime().exec((String[])cmdarray);
            BufferedInputStream output = new BufferedInputStream(p.getInputStream());
            BufferedInputStream error = new BufferedInputStream(p.getErrorStream());
            boolean repeat = true;
            while (repeat) {
                int nRead;
                byte[] data;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (output.available() > 0) {
                    data = new byte[output.available()];
                    nRead = output.read(data);
                    System.err.println("read " + nRead + " bytes from output stream");
                }
                if (error.available() > 0) {
                    data = new byte[error.available()];
                    nRead = error.read(data);
                    System.err.println("read " + nRead + " bytes from error stream");
                }
                try {
                    p.exitValue();
                    repeat = false;
                    System.out.println("process terminated with exit code " + p.exitValue());
                }
                catch (IllegalThreadStateException e) {
                    repeat = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WalaException("IOException in " + DotUtil.class);
        }
    }

    public static <T> File writeDotFile(Graph<T> g, NodeDecorator labels, String dotfile) throws WalaException {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        StringBuffer dotStringBuffer = DotUtil.dotOutput(g, labels);
        if (dotfile == null) {
            throw new WalaException("internal error: null filename parameter");
        }
        try {
            File f = new File(dotfile);
            FileWriter fw = new FileWriter(f);
            fw.write(dotStringBuffer.toString());
            fw.close();
            return f;
        }
        catch (Exception e) {
            throw new WalaException("Error writing dot file " + dotfile);
        }
    }

    private static <T> StringBuffer dotOutput(Graph<T> g, NodeDecorator labels) throws WalaException {
        StringBuffer result = new StringBuffer("digraph \"DirectedGraph\" {\n");
        String rankdir = DotUtil.getRankDir();
        if (rankdir != null) {
            result.append("rankdir=" + rankdir + ";");
        }
        result.append("center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        Collection<T> dotNodes = DotUtil.computeDotNodes(g);
        DotUtil.outputNodes(labels, result, dotNodes);
        for (Object n : g) {
            Iterator it2 = g.getSuccNodes(n);
            while (it2.hasNext()) {
                Object s = it2.next();
                result.append(" ");
                result.append(DotUtil.getPort(n, labels));
                result.append(" -> ");
                result.append(DotUtil.getPort(s, labels));
                result.append(" \n");
            }
        }
        result.append("\n}");
        return result;
    }

    private static void outputNodes(NodeDecorator labels, StringBuffer result, Collection dotNodes) throws WalaException {
        Iterator it = dotNodes.iterator();
        while (it.hasNext()) {
            DotUtil.outputNode(labels, result, it.next());
        }
    }

    private static void outputNode(NodeDecorator labels, StringBuffer result, Object n) throws WalaException {
        result.append("   ");
        result.append("\"");
        result.append(DotUtil.getLabel(n, labels));
        result.append("\"");
        result.append(DotUtil.decorateNode(n, labels));
    }

    private static <T> Collection<T> computeDotNodes(Graph<T> g) throws WalaException {
        return Iterator2Collection.toCollection(g.iterator());
    }

    private static String getRankDir() throws WalaException {
        return null;
    }

    private static String decorateNode(Object n, NodeDecorator d) throws WalaException {
        StringBuffer result = new StringBuffer();
        result.append(" [shape=\"box\" color=\"blue\"");
        result.append("] \n");
        return result.toString();
    }

    private static String getLabel(Object o, NodeDecorator d) throws WalaException {
        String result = null;
        if (d == null) {
            result = o.toString();
        } else {
            result = d.getLabel(o);
            String string = result = result == null ? o.toString() : result;
        }
        if (result.length() >= 75) {
            result = String.valueOf(result.substring(0, 72)) + "...";
        }
        return result;
    }

    private static String getPort(Object o, NodeDecorator d) throws WalaException {
        return "\"" + DotUtil.getLabel(o, d) + "\"";
    }
}

