/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.cfg.CFGSanitizer;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.util.StringStuff;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeDecorator;
import com.ibm.wala.util.warnings.WalaException;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.GVUtil;
import java.util.HashMap;
import java.util.Iterator;

public class GhostviewUtil {
    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String psFile, String dotFile, String dotExe, String gvExe) throws WalaException {
        return GhostviewUtil.ghostviewIR(cha, ir, psFile, dotFile, dotExe, gvExe, null);
    }

    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String psFile, String dotFile, String dotExe, String gvExe, NodeDecorator annotations) throws WalaException {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        Graph<ISSABasicBlock> g = ir.getControlFlowGraph();
        NodeDecorator labels = GhostviewUtil.makeIRDecorator(ir);
        if (annotations != null) {
            labels = new ConcatenatingNodeDecorator(annotations, labels);
        }
        g = CFGSanitizer.sanitize(ir, cha);
        DotUtil.dotify(g, labels, dotFile, psFile, dotExe);
        return GVUtil.launchGV(psFile, gvExe);
    }

    public static NodeDecorator makeIRDecorator(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        final HashMap<SSACFG.BasicBlock, String> labelMap = HashMapFactory.make();
        for (SSACFG.BasicBlock bb : ir.getControlFlowGraph()) {
            labelMap.put(bb, GhostviewUtil.getNodeLabel(ir, bb));
        }
        NodeDecorator labels = new NodeDecorator(){

            public String getLabel(Object o) {
                return (String)labelMap.get(o);
            }
        };
        return labels;
    }

    private static String getNodeLabel(IR ir, SSACFG.BasicBlock bb) {
        StringBuffer result = new StringBuffer();
        int start = bb.getFirstInstructionIndex();
        int end = bb.getLastInstructionIndex();
        result.append("BB").append(bb.getNumber());
        if (bb.isEntryBlock()) {
            result.append(" (en)\\n");
        } else if (bb.isExitBlock()) {
            result.append(" (ex)\\n");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            result.append("<Handler>");
        }
        result.append("\\n");
        Iterator<SSAPhiInstruction> it = bb.iteratePhis();
        while (it.hasNext()) {
            SSAPhiInstruction phi = it.next();
            if (phi == null) continue;
            result.append("           " + phi.toString()).append("\\n");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            SSACFG.ExceptionHandlerBasicBlock ebb = (SSACFG.ExceptionHandlerBasicBlock)bb;
            SSAGetCaughtExceptionInstruction s = ebb.getCatchInstruction();
            if (s != null) {
                result.append("           " + s.toString()).append("\\n");
            } else {
                result.append("            No catch instruction. Unreachable?\\n");
            }
        }
        SSAInstruction[] instructions = ir.getInstructions();
        int j = start;
        while (j <= end) {
            if (instructions[j] != null) {
                StringBuffer x = new StringBuffer(String.valueOf(j) + "   " + instructions[j].toString());
                StringStuff.padWithSpaces(x, 35);
                result.append(x);
                result.append("\\n");
            }
            ++j;
        }
        Iterator<SSAPiInstruction> it2 = bb.iteratePis();
        while (it2.hasNext()) {
            SSAPiInstruction pi = it2.next();
            if (pi == null) continue;
            result.append("           " + pi.toString()).append("\\n");
        }
        return result.toString();
    }

    private static final class ConcatenatingNodeDecorator
    implements NodeDecorator {
        private final NodeDecorator A;
        private final NodeDecorator B;

        ConcatenatingNodeDecorator(NodeDecorator A, NodeDecorator B) {
            this.A = A;
            this.B = B;
        }

        public String getLabel(Object o) throws WalaException {
            return String.valueOf(this.A.getLabel(o)) + this.B.getLabel(o);
        }
    }
}

