/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.warnings.WalaException;
import com.ibm.wala.viz.SWTTreeViewer;
import com.ibm.wala.viz.ViewIFDSLocalAction;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.jface.action.IAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFDSExplorer {
    protected static String dotExe = null;
    protected static String gvExe = null;

    public static void setDotExe(String newDotExe) {
        dotExe = newDotExe;
    }

    public static void setGvExe(String newGvExe) {
        gvExe = newGvExe;
    }

    public static <T, P> void viewIFDS(TabulationResult<T, P> r) throws WalaException {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        assert (gvExe != null);
        assert (dotExe != null);
        System.err.println("Domain:\n" + r.getProblem().getDomain().toString());
        Trace.println("Domain:\n" + r.getProblem().getDomain().toString());
        Properties p = null;
        try {
            p = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
        String psFile = String.valueOf(p.getProperty("output_dir")) + File.separatorChar + "ir.ps";
        String dotFile = String.valueOf(p.getProperty("output_dir")) + File.separatorChar + "ir.dt";
        SWTTreeViewer v = new SWTTreeViewer();
        Graph<P> g = r.getProblem().getSupergraph().getProcedureGraph();
        v.setGraphInput(g);
        v.setBlockInput(true);
        Collection roots = Collections.singleton(r.getProblem().getSupergraph().getMain());
        v.setRootsInput(roots);
        v.getPopUpActions().add((IAction)new ViewIFDSLocalAction<T, P>(v, r, psFile, dotFile, dotExe, gvExe));
        v.run();
    }

    public static String getDotExe() {
        return dotExe;
    }

    public static String getGvExe() {
        return gvExe;
    }
}

