/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.graph.NodeDecorator;
import com.ibm.wala.util.warnings.WalaException;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.GVUtil;
import com.ibm.wala.viz.SWTTreeViewer;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewIFDSLocalAction<T, P>
extends Action {
    private final SWTTreeViewer viewer;
    private final ISupergraph<T, P> supergraph;
    private final String psFile;
    private final String dotFile;
    private final String dotExe;
    private final String gvExe;
    private final NodeDecorator labels;

    public ViewIFDSLocalAction(SWTTreeViewer viewer, TabulationResult<T, P> result, String psFile, String dotFile, String dotExe, String gvExe) {
        this.viewer = viewer;
        this.supergraph = result.getProblem().getSupergraph();
        this.psFile = psFile;
        this.dotFile = dotFile;
        this.dotExe = dotExe;
        this.gvExe = gvExe;
        this.labels = new Labels(result);
        this.setText("View Local Supergraph");
    }

    public void run() {
        try {
            final P proc = this.getProcedureForSelection();
            Filter filter = new Filter<T>(){

                @Override
                public boolean accepts(T o) {
                    return ViewIFDSLocalAction.this.supergraph.getProcOf(o).equals(proc);
                }
            };
            Graph localGraph = GraphSlicer.prune(this.supergraph, filter);
            System.err.println("Spawn Viewer for " + proc);
            DotUtil.dotify(localGraph, this.labels, this.dotFile, this.psFile, this.dotExe);
            GVUtil.launchGV(this.psFile, this.gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    protected P getProcedureForSelection() {
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection.size() != 1) {
            throw new UnsupportedOperationException("did not expect selection of size " + selection.size());
        }
        Object first = selection.getFirstElement();
        return (P)first;
    }

    protected SWTTreeViewer getViewer() {
        return this.viewer;
    }

    protected ISupergraph<T, P> getSupergraph() {
        return this.supergraph;
    }

    protected String getDotExe() {
        return this.dotExe;
    }

    protected String getDotFile() {
        return this.dotFile;
    }

    protected String getGvExe() {
        return this.gvExe;
    }

    protected String getPsFile() {
        return this.psFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Labels
    implements NodeDecorator {
        private TabulationResult<T, P> result;

        Labels(TabulationResult<T, P> result) {
            this.result = result;
        }

        @Override
        public String getLabel(Object o) throws WalaException {
            BasicBlockInContext bb;
            Object t = o;
            if (t instanceof BasicBlockInContext && (bb = (BasicBlockInContext)t).getDelegate() instanceof ExplodedControlFlowGraph.ExplodedBasicBlock) {
                ExplodedControlFlowGraph.ExplodedBasicBlock delegate = (ExplodedControlFlowGraph.ExplodedBasicBlock)bb.getDelegate();
                String s = String.valueOf(delegate.getNumber()) + " " + this.result.getResult(t) + " " + delegate.getInstruction();
                Iterator<SSAPhiInstruction> phis = delegate.iteratePhis();
                while (phis.hasNext()) {
                    SSAPhiInstruction phi = phis.next();
                    s = String.valueOf(s) + " " + phi;
                }
                if (delegate.isCatchBlock()) {
                    s = String.valueOf(s) + " " + delegate.getCatchInstruction();
                }
                return s;
            }
            return t + " " + this.result.getResult(t);
        }
    }
}

