/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.BooleanArrayOperations;
import hj.array.Helper;
import hj.array.Operator;
import hj.lang.ArrayOperations;
import hj.lang.BooleanReferenceArray;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.booleanArray;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Place;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class BooleanArray
extends BooleanReferenceArray {
    public BooleanArray(dist d, boolean mutable) {
        super(d, mutable);
    }

    protected abstract BooleanArray newInstance(dist var1);

    protected abstract BooleanArray newInstance(dist var1, boolean var2);

    protected final BooleanArray newInstance(dist d, Operator.Pointwise p) {
        BooleanArray res = this.newInstance(d);
        if (p != null) {
            ArrayOperations.scan(res, p, (booleanArray)this);
        }
        return res;
    }

    public abstract boolean getOrdinal(int var1);

    public abstract boolean setOrdinal(boolean var1, int var2);

    public boolean set(boolean v, point pos) {
        return this.set(v, pos, true, true);
    }

    public boolean set(boolean v, point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public boolean set(boolean v, int d0) {
        return this.set(v, d0, true, true);
    }

    public boolean set(boolean v, int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public boolean set(boolean v, int d0, int d1) {
        return this.set(v, d0, d1, true, true);
    }

    public boolean set(boolean v, int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public boolean set(boolean v, int d0, int d1, int d2) {
        return this.set(v, d0, d1, d2, true, true);
    }

    public boolean set(boolean v, int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public boolean set(boolean v, int d0, int d1, int d2, int d3) {
        return this.set(v, d0, d1, d2, d3, true, true);
    }

    public boolean set(boolean v, int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public boolean get(point pos) {
        return this.get(pos, true, true);
    }

    public boolean get(point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public boolean get(int d0) {
        return this.get(d0, true, true);
    }

    public boolean get(int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public boolean get(int d0, int d1) {
        return this.get(d0, d1, true, true);
    }

    public boolean get(int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public boolean get(int d0, int d1, int d2) {
        return this.get(d0, d1, d2, true, true);
    }

    public boolean get(int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public boolean get(int d0, int d1, int d2, int d3) {
        return this.get(d0, d1, d2, d3, true, true);
    }

    public boolean get(int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.getOrdinal(theIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEquals(Indexable other) {
        BooleanArray o = (BooleanArray)other;
        if (!o.distribution.equals(this.distribution)) {
            return false;
        }
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                if (this.get(pos) == o.get(pos)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assign(BooleanArray rhs) {
        assert (rhs instanceof BooleanArray);
        assert (rhs.distribution.equals(this.distribution));
        Place here = Runtime.runtime.currentPlace();
        BooleanArray rhs_t = rhs;
        try {
            Iterator it = rhs_t.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(rhs_t.get(pos), pos);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    public void reduction(Operator.Reduction op) {
        ArrayOperations.reduction(this, op);
    }

    public boolean bitAndSet(boolean v, point p) {
        return BooleanArrayOperations.bitAndSet((BooleanReferenceArray)this, v, p);
    }

    public boolean bitAndSet(boolean v, int p) {
        return BooleanArrayOperations.bitAndSet((BooleanReferenceArray)this, v, p);
    }

    public boolean bitAndSet(boolean v, int p, int q) {
        return BooleanArrayOperations.bitAndSet(this, v, p, q);
    }

    public boolean bitAndSet(boolean v, int p, int q, int r) {
        return BooleanArrayOperations.bitAndSet(this, v, p, q, r);
    }

    public boolean bitAndSet(boolean v, int p, int q, int r, int s) {
        return BooleanArrayOperations.bitAndSet(this, v, p, q, r, s);
    }

    public boolean bitOrSet(boolean v, point p) {
        return BooleanArrayOperations.bitOrSet((BooleanReferenceArray)this, v, p);
    }

    public boolean bitOrSet(boolean v, int p) {
        return BooleanArrayOperations.bitOrSet((BooleanReferenceArray)this, v, p);
    }

    public boolean bitOrSet(boolean v, int p, int q) {
        return BooleanArrayOperations.bitOrSet(this, v, p, q);
    }

    public boolean bitOrSet(boolean v, int p, int q, int r) {
        return BooleanArrayOperations.bitOrSet(this, v, p, q, r);
    }

    public boolean bitOrSet(boolean v, int p, int q, int r, int s) {
        return BooleanArrayOperations.bitOrSet(this, v, p, q, r, s);
    }

    public boolean bitXorSet(boolean v, point p) {
        return BooleanArrayOperations.bitXorSet((BooleanReferenceArray)this, v, p);
    }

    public boolean bitXorSet(boolean v, int p) {
        return BooleanArrayOperations.bitXorSet((BooleanReferenceArray)this, v, p);
    }

    public boolean bitXorSet(boolean v, int p, int q) {
        return BooleanArrayOperations.bitXorSet(this, v, p, q);
    }

    public boolean bitXorSet(boolean v, int p, int q, int r) {
        return BooleanArrayOperations.bitXorSet(this, v, p, q, r);
    }

    public boolean bitXorSet(boolean v, int p, int q, int r, int s) {
        return BooleanArrayOperations.bitXorSet(this, v, p, q, r, s);
    }

    public Object toJava() {
        final int[] dims_tmp = new int[this.distribution.rank];
        for (int i = 0; i < this.distribution.rank; ++i) {
            dims_tmp[i] = this.distribution.region.rank(i).high() + 1;
        }
        final Object ret = Array.newInstance(Boolean.TYPE, dims_tmp);
        ArrayOperations.pointwise(this, null, new Operator.Pointwise(){

            public boolean apply(point p, boolean arg) {
                int i;
                Object handle = ret;
                for (i = 0; i < dims_tmp.length - 1; ++i) {
                    handle = Array.get(handle, p.get(i));
                }
                Array.setBoolean(handle, p.get(i), arg);
                return arg;
            }
        });
        return ret;
    }

    public booleanArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        throw new Error("TODO: <T>ReferenceArray --> <T>ValueArray");
    }
}

