/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.MultiDimRegion;
import hj.array.point_c;
import hj.lang.RankMismatchException;
import hj.lang.dist;
import hj.lang.point;
import hj.lang.region;

public class Helper {
    public static final boolean performBoundsCheck = true;
    public static final boolean simpleRangeCheck = false;

    static final void checkBounds(region r, int d0) {
        try {
            if (r instanceof MultiDimRegion && r.isConvex()) {
                MultiDimRegion mdr = (MultiDimRegion)r;
                int lowd0 = mdr.rank(0).low();
                int highd0 = mdr.rank(0).high();
                if (d0 < lowd0 || d0 > highd0) {
                    System.err.println("IndexError. d0=|" + d0 + "|, lowd0 = " + lowd0 + "|, highd0=|" + highd0 + r);
                    throw new ArrayIndexOutOfBoundsException();
                }
            } else {
                int[] index = new int[]{d0};
                if (!r.contains(index)) {
                    System.err.println("IndexError=|" + d0 + "|, r = " + r);
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static final void rangeCheck(region r, int index) {
        if (index < 0 || index >= r.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static int ordinal(dist d, point p, boolean chkAOB) {
        int theIndex = d.region.ordinal(p);
        return theIndex;
    }

    public static int ordinal(dist d, int d0, boolean chkAOB) {
        int index;
        region r = d.region;
        if (r.rank != 1) {
            throw new RankMismatchException(r, 1);
        }
        if (chkAOB) {
            Helper.checkBounds(r, d0);
        }
        try {
            index = !r.isConvex() ? r.ordinal(point_c.factory.point(d0)) : d0 - r.rank(0).low();
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return index;
    }

    public static int rawordinal(region r, int d0, boolean chkAOB) {
        if (r.rank != 1) {
            throw new RankMismatchException(r, 1);
        }
        if (chkAOB) {
            Helper.checkBounds(r, d0);
        } else if (chkAOB) {
            // empty if block
        }
        return d0;
    }

    static final void checkBounds(region r, int d0, int d1) {
        try {
            if (r instanceof MultiDimRegion && r.isConvex()) {
                MultiDimRegion mdr = (MultiDimRegion)r;
                int lowd0 = mdr.rank(0).low();
                int lowd1 = mdr.rank(1).low();
                int highd0 = mdr.rank(0).high();
                int highd1 = mdr.rank(1).high();
                if (d0 < lowd0 || d0 > highd0 || d1 < lowd1 || d1 > highd1) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            } else {
                int[] index = new int[]{d0, d1};
                if (!r.contains(index)) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static int ordinal(dist d, int d0, int d1, boolean chkAOB) {
        int index;
        region r = d.region;
        if (r.rank != 2) {
            throw new RankMismatchException(r, 2);
        }
        if (chkAOB) {
            Helper.checkBounds(r, d0, d1);
        }
        try {
            index = !r.isConvex() ? r.ordinal(point_c.factory.point(d0, d1)) : (d1 -= r.rank(1).low()) + (d0 -= r.rank(0).low()) * r.rank(1).size();
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return index;
    }

    public static final int rawordinal(region r, int d0, int d1, boolean chkAOB) {
        if (r.rank != 2) {
            throw new RankMismatchException(r, 2);
        }
        Helper.checkBounds(r, d0, d1);
        int index = d1 + d0 * r.rank(1).size();
        if (chkAOB) {
            // empty if block
        }
        return index;
    }

    static final void checkBounds(region r, int d0, int d1, int d2) {
        try {
            if (r instanceof MultiDimRegion && r.isConvex()) {
                MultiDimRegion mdr = (MultiDimRegion)r;
                int lowd0 = mdr.rank(0).low();
                int lowd1 = mdr.rank(1).low();
                int lowd2 = mdr.rank(2).low();
                int highd0 = mdr.rank(0).high();
                int highd1 = mdr.rank(1).high();
                int highd2 = mdr.rank(2).high();
                if (d0 < lowd0 || d0 > highd0 || d1 < lowd1 || d1 > highd1 || d2 < lowd2 || d2 > highd2) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            } else {
                int[] index = new int[]{d0, d1, d2};
                if (!r.contains(index)) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static int ordinal(dist d, int d0, int d1, int d2, boolean chkAOB) {
        int index;
        region r = d.region;
        if (r.rank != 3) {
            throw new RankMismatchException(r, 3);
        }
        if (chkAOB) {
            Helper.checkBounds(r, d0, d1, d2);
        }
        try {
            if (!r.isConvex()) {
                index = r.ordinal(point_c.factory.point(d0, d1, d2));
            } else {
                int d1Size = r.rank(2).size();
                int d0Size = d1Size * r.rank(1).size();
                index = (d2 -= r.rank(2).low()) + (d1 -= r.rank(1).low()) * d1Size + (d0 -= r.rank(0).low()) * d0Size;
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return index;
    }

    public static final int rawordinal(region r, int d0, int d1, int d2, boolean chkAOB) {
        if (r.rank != 3) {
            throw new RankMismatchException(r, 3);
        }
        int d1Size = r.rank(2).size();
        int d0Size = d1Size * r.rank(1).size();
        int index = d2 + d1 * d1Size + d0 * d0Size;
        if (chkAOB) {
            // empty if block
        }
        return index;
    }

    static final void checkBounds(region r, int d0, int d1, int d2, int d3) {
        try {
            if (r instanceof MultiDimRegion && r.isConvex()) {
                MultiDimRegion mdr = (MultiDimRegion)r;
                int lowd0 = mdr.rank(0).low();
                int lowd1 = mdr.rank(1).low();
                int lowd2 = mdr.rank(2).low();
                int lowd3 = mdr.rank(3).low();
                int highd0 = mdr.rank(0).high();
                int highd1 = mdr.rank(1).high();
                int highd2 = mdr.rank(2).high();
                int highd3 = mdr.rank(3).high();
                if (d0 < lowd0 || d0 > highd0 || d1 < lowd1 || d1 > highd1 || d2 < lowd2 || d2 > highd2 || d3 < lowd3 || d3 > highd3) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            } else {
                int[] index = new int[]{d0, d1, d2, d3};
                if (!r.contains(index)) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static int ordinal(dist d, int d0, int d1, int d2, int d3, boolean chkAOB) {
        int index;
        region r = d.region;
        if (r.rank != 4) {
            throw new RankMismatchException(r, 4);
        }
        Helper.checkBounds(r, d0, d1, d2, d3);
        try {
            if (!r.isConvex()) {
                index = r.ordinal(point_c.factory.point(d0, d1, d2, d3));
            } else {
                int d2Size = r.rank(3).size();
                int d1Size = d2Size * r.rank(2).size();
                int d0Size = d1Size * r.rank(1).size();
                index = (d3 -= r.rank(3).low()) + (d2 -= r.rank(2).low()) * d2Size + (d1 -= r.rank(1).low()) * d1Size + (d0 -= r.rank(0).low()) * d0Size;
            }
        }
        catch (UnsupportedOperationException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return index;
    }

    public static final int rawordinal(region r, int d0, int d1, int d2, int d3, boolean chkAOB) {
        if (r.rank != 4) {
            throw new RankMismatchException(r, 4);
        }
        if (chkAOB) {
            Helper.checkBounds(r, d0, d1, d2, d3);
        }
        int d2Size = r.rank(3).size();
        int d1Size = d2Size * r.rank(2).size();
        int d0Size = d1Size * r.rank(1).size();
        int index = d3 + d2 * d2Size + d1 * d1Size + d0 * d0Size;
        return index;
    }
}

