/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ArbitraryRegion;
import hj.array.ContiguousRange;
import hj.array.EmptyRegion;
import hj.array.Range;
import hj.array.Rectangular;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;
import java.util.Iterator;

public class MultiDimRegion
extends region
implements Rectangular {
    final region[] dims_;
    final int[] base_;
    final int card;

    public MultiDimRegion(region[] d, boolean zeroBased) {
        super(d.length, true, zeroBased);
        assert (d != null);
        this.dims_ = new region[d.length];
        for (int i = 0; i < this.dims_.length; ++i) {
            this.dims_[i] = d[i];
            if (zeroBased) assert (d[i].zeroBased);
        }
        int tmp_card = 1;
        this.base_ = new int[this.dims_.length];
        for (int i = this.rank - 1; i >= 0; --i) {
            this.base_[i] = tmp_card;
            tmp_card *= this.dims_[i].size();
        }
        this.card = tmp_card;
    }

    public MultiDimRegion(int[] d) {
        super(d.length, true, true);
        assert (d != null);
        this.dims_ = new region[d.length];
        for (int i = 0; i < this.dims_.length; ++i) {
            this.dims_[i] = new ContiguousRange(d[i]);
        }
        int tmp_card = 1;
        this.base_ = new int[this.dims_.length];
        for (int i = this.rank - 1; i >= 0; --i) {
            this.base_[i] = tmp_card;
            tmp_card *= this.dims_[i].size();
        }
        this.card = tmp_card;
    }

    public region[] partition(int n, int dim_to_split) {
        assert (n > 0);
        if (!(this.dims_[dim_to_split] instanceof ContiguousRange)) {
            throw new Error("MultiDimRegion::partition can only block those arrays that have a contiguous dimension to split.");
        }
        ContiguousRange cr = (ContiguousRange)this.dims_[dim_to_split];
        if (cr.size() < n) {
            throw new Error("MultiDimRegion::partition can only block those arrays that have size of dimension of the dimension to split larger than or equal to number of partitions.");
        }
        region[] ret = new region[n];
        if (n == 1) {
            ret[0] = this;
        } else {
            region[] split_dim = cr.partition(n, 0);
            for (int i = 0; i < n; ++i) {
                if (split_dim[i].size() == 0) {
                    ret[i] = new EmptyRegion(this.rank);
                    continue;
                }
                boolean zeroBased = true;
                region[] new_dims = new region[this.rank];
                new_dims[dim_to_split] = split_dim[i];
                zeroBased &= new_dims[dim_to_split].zeroBased;
                for (int j = 0; j < this.rank; ++j) {
                    if (j == dim_to_split) continue;
                    new_dims[j] = this.dims_[j];
                    zeroBased &= new_dims[j].zeroBased;
                }
                ret[i] = new MultiDimRegion(new_dims, zeroBased);
            }
        }
        return ret;
    }

    public region union(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.union(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(this.rank);
        }
        return ret;
    }

    public region intersection(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.intersection(this, r);
        if (ret.size() == 0) {
            ret = new EmptyRegion(this.rank);
        }
        return ret;
    }

    public region difference(region d) {
        assert (d != null);
        if (d instanceof MultiDimRegion && this.rank == 2 && d.rank == 2) {
            MultiDimRegion d2 = (MultiDimRegion)d;
            region[] tmp = null;
            if (this.dims_[0].equals(d2.dims_[0])) {
                tmp = new region[]{this.dims_[0], this.dims_[1].difference(d2.dims_[1])};
            } else if (this.dims_[1].equals(d2.dims_[1])) {
                tmp = new region[2];
                tmp[1] = this.dims_[1];
                tmp[0] = this.dims_[0].difference(d2.dims_[0]);
            }
            if (tmp != null && tmp[0] instanceof ContiguousRange && tmp[1] instanceof ContiguousRange) {
                return new MultiDimRegion(tmp, false);
            }
        }
        return ArbitraryRegion.difference(this, d);
    }

    public region rank(int i) {
        assert (i < this.dims_.length);
        assert (i >= 0);
        return this.dims_[i];
    }

    public boolean contains(region r) {
        assert (r != null);
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        boolean ret = true;
        if (r instanceof MultiDimRegion) {
            MultiDimRegion r_c = (MultiDimRegion)r;
            for (int i = 0; i < r_c.rank && ret; ++i) {
                ret = this.dims_[i].contains(r_c.dims_[i]);
            }
        } else {
            ret = super.contains(r);
        }
        return ret;
    }

    public boolean contains(point p) {
        boolean ret;
        if (p.rank == this.rank) {
            ret = true;
            for (int i = 0; ret && i < this.rank; ++i) {
                int[] coord = new int[]{p.get(i)};
                ret = this.dims_[i].contains(coord);
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean contains(int[] val) {
        boolean ret;
        if (val.length == this.rank) {
            ret = true;
            for (int i = 0; ret && i < this.rank; ++i) {
                int[] coord = new int[]{val[i]};
                ret = this.dims_[i].contains(coord);
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public int size() {
        return this.card;
    }

    public int ordinal(point p) {
        if (p.rank != this.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        int ret = 0;
        int base = 1;
        for (int i = p.rank - 1; i >= 0; --i) {
            Range r = (Range)this.dims_[i];
            ret += r.ordinal(p.get(i)) * base;
            base *= r.size;
        }
        return ret;
    }

    public Iterator iterator() {
        return new MultiDimRegionIterator_();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < this.rank; ++i) {
            sb.append(this.dims_[i].toString());
            if (i >= this.rank - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public region convexHull() {
        region ret;
        if (this.isConvex()) {
            ret = this;
        } else if (this.rank == 1) {
            ret = new ContiguousRange(this.low(), this.high());
        } else {
            region[] dims = new region[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                dims[i] = this.dims_[i].isConvex() ? this.dims_[i] : this.dims_[i].convexHull();
            }
            ret = new MultiDimRegion(dims, this.zeroBased);
        }
        return ret;
    }

    public boolean disjoint(region r) {
        boolean ret = true;
        if (r.rank == this.rank) {
            Iterator it = r.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                if (!this.contains(p)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public int high() {
        if (this.rank != 1) {
            throw new UnsupportedOperationException();
        }
        return this.dims_[0].high();
    }

    public int low() {
        if (this.rank != 1) {
            throw new UnsupportedOperationException();
        }
        return this.dims_[0].low();
    }

    public boolean isConvex() {
        boolean ret = true;
        for (int i = 0; i < this.rank && ret; ret &= this.dims_[i].isConvex(), ++i) {
        }
        return ret;
    }

    public point coord(int ordinal) throws ArrayIndexOutOfBoundsException {
        assert (ordinal < this.size());
        int[] ret = new int[this.rank];
        int rest = ordinal;
        boolean base = false;
        for (int i = 0; i < this.rank; ++i) {
            region r = this.dims_[i];
            int tmp = rest / this.base_[i];
            rest %= this.base_[i];
            ret[i] = r.coord(tmp).get(0);
        }
        return point.factory.point(ret);
    }

    private class MultiDimRegionIterator_
    implements Iterator {
        private int nextOrd_ = 0;

        private MultiDimRegionIterator_() {
        }

        public boolean hasNext() {
            return this.nextOrd_ < MultiDimRegion.this.card;
        }

        public void remove() {
            throw new Error("not implemented");
        }

        public Object next() {
            assert (this.hasNext());
            return MultiDimRegion.this.coord(this.nextOrd_++);
        }
    }
}

