/*
 * Decompiled with CFR 0.152.
 */
package hj.lang;

import hj.array.ArrayFactory;
import hj.lang.BadPlaceException;
import hj.lang.Exception;
import hj.lang.Indexable;
import hj.lang.JavaRuntime;
import hj.lang.Object;
import hj.lang.ValueType;
import hj.lang.accumulator;
import hj.lang.activity;
import hj.lang.clock;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import hj.runtime.common.ConfigurationError;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.util.ShowUsageNotification;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.StringTokenizer;

public abstract class Runtime {
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_ERROR_RUNTIME = 201;
    public static final int EXIT_CODE_ERROR_APPLICATION = 202;
    public static Runtime runtime;
    public static JavaRuntime java;
    private static boolean done_;
    public static Factory factory;
    public static final String LANGUAGE = "hj";
    protected static final int USAGE_SCREEN_WIDTH = 76;
    private static final int USAGE_FLAG_WIDTH = 34;
    private static final int USAGE_FLAG_INDENT = 4;
    private static int exitCode;

    public static void init() {
        assert (!done_);
        done_ = true;
        Class rt = Configuration.getRuntimeClass();
        assert (rt != null);
        try {
            runtime = (Runtime)rt.newInstance();
            java = new JavaRuntime();
            factory = runtime.getFactory();
        }
        catch (IllegalAccessException iae) {
            System.err.println("Runtime::<clinit> could not access runtime " + rt);
            throw new Error(iae);
        }
        catch (InstantiationException ie) {
            System.err.println("Runtime::<clinit> could not create runtime " + rt);
            throw new Error(ie);
        }
        catch (Throwable t) {
            System.err.println("Runtime::<clinit> unknown exception during creation of runtime " + rt);
            throw new Error(t);
        }
    }

    protected abstract void initialize();

    public static void main(String[] args) {
        Runtime.exit(Runtime.mainEntry(args));
    }

    public static int mainEntry(String[] args) {
        try {
            String[] args_stripped = Configuration.parseCommandLine(args);
            Runtime.init();
            runtime.run(args_stripped);
        }
        catch (ShowUsageNotification e) {
            Runtime.usage(System.out, null);
            return 201;
        }
        catch (ConfigurationError e) {
            Runtime.usage(System.err, e);
            return 201;
        }
        catch (Exception e) {
            java.error("Unexpected Exception in Hj Runtime.", e);
            return 201;
        }
        return exitCode;
    }

    public static void usage(PrintStream out, ConfigurationError err) {
        if (err != null) {
            out.println("Error: " + err.getMessage());
        }
        out.println("Usage: hj [options] <main-class> [arg0 arg1 ...]");
        out.println("where [options] includes:");
        String[][] options = Configuration.options();
        for (int i = 0; i < options.length; ++i) {
            String[] optinfo = options[i];
            String optflag = "-" + optinfo[0] + "=" + optinfo[1];
            String optdesc = optinfo[2] + "(default = " + optinfo[3] + ")";
            Runtime.usageForFlag(out, optflag, optdesc);
        }
    }

    protected static void printSpaces(PrintStream out, int n) {
        while (n-- > 0) {
            out.print(' ');
        }
    }

    protected static void usageForFlag(PrintStream out, String flag, String description) {
        Runtime.printSpaces(out, 4);
        out.print(flag);
        int cur = flag.length() + 4;
        if (cur < 34) {
            Runtime.printSpaces(out, 34 - cur);
        } else {
            out.println();
            Runtime.printSpaces(out, 34);
        }
        cur = 34;
        StringTokenizer st = new StringTokenizer(description);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (cur + s.length() > 76) {
                out.println();
                Runtime.printSpaces(out, 34);
                cur = 34;
            }
            out.print(s);
            cur += s.length();
            if (!st.hasMoreTokens()) continue;
            if (cur + 1 > 76) {
                out.println();
                Runtime.printSpaces(out, 34);
                cur = 34;
                continue;
            }
            out.print(" ");
            ++cur;
        }
        out.println();
    }

    public static void setExitCode(int code) {
        if (exitCode == 0) {
            exitCode = code;
        }
    }

    public static void hjExit() {
        if (Report.should_report("activity", 3)) {
            Thread t = Thread.currentThread();
            Report.report(3, t + "@" + System.currentTimeMillis() + " The XVM is now terminating.");
        }
        System.exit(exitCode);
    }

    public static void exit(int code) {
        Runtime.setExitCode(code);
        Runtime.hjExit();
    }

    public static boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected Runtime() {
    }

    public abstract Factory getFactory();

    protected abstract void run(String[] var1) throws Exception;

    public abstract void setCurrentPlace(place var1);

    public abstract Place currentPlace();

    public abstract activity currentActivity();

    protected abstract Place[] getPlaces();

    protected abstract Place getPlace0();

    public abstract void prepareForBoot();

    public abstract void shutdown();

    public static Place here() {
        Place p = runtime.currentPlace();
        assert (p != null);
        return p;
    }

    public static place asPlace(place p) {
        return p == null ? Runtime.here() : p;
    }

    public static void hereCheckPlace(place p) {
        if (p != ((PoolRunner)Thread.currentThread()).getPlace()) {
            throw new BadPlaceException(p, (place)Runtime.here());
        }
    }

    public static java.lang.Object hereCheck(java.lang.Object o) {
        if (Configuration.BAD_PLACE_RUNTIME_CHECK && o != null && o instanceof Object && !(o instanceof ValueType)) {
            Runtime.hereCheckPlace(((Object)o).getLocation());
        }
        return o;
    }

    public static java.lang.Object placeCheck(java.lang.Object o, place p) {
        if (o == null) {
            throw new ClassCastException("Place-cast of value 'null' failed.");
        }
        if (!(o instanceof Object)) {
            throw new Error("Place-cast currently not available for object of type " + o.getClass().getName());
        }
        Object xo = (Object)o;
        if (!xo.getLocation().equals(p)) {
            throw new BadPlaceException(xo, (place)Runtime.here());
        }
        return o;
    }

    public static activity getCurrentActivity() {
        return runtime.currentActivity();
    }

    public static Place[] places() {
        Place[] pl = runtime.getPlaces();
        Place[] ret = new Place[pl.length];
        System.arraycopy(pl, 0, ret, 0, pl.length);
        return ret;
    }

    public static Place place0() {
        return runtime.getPlace0();
    }

    public static Place getDefaultPlace() {
        return runtime.getPlaces()[0];
    }

    public static boolean equalsequals(java.lang.Object o1, java.lang.Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c = o1.getClass();
        if (o1 instanceof Indexable && o2 instanceof Indexable) {
            Indexable i1 = (Indexable)o1;
            Indexable i2 = (Indexable)o2;
            if (!i1.isValue() || !i2.isValue()) {
                return false;
            }
            return i1.valueEquals(i2);
        }
        if (c != o2.getClass()) {
            return false;
        }
        if (!(o1 instanceof ValueType)) {
            return false;
        }
        try {
            while (c != null) {
                Field[] fs = c.getDeclaredFields();
                for (int i = fs.length - 1; i >= 0; --i) {
                    Field f = fs[i];
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    f.setAccessible(true);
                    if (f.getType().isPrimitive()) {
                        if (f.get(o1).equals(f.get(o2))) continue;
                        return false;
                    }
                    if (f.getType().isArray()) {
                        java.lang.Object a1 = f.get(o1);
                        java.lang.Object a2 = f.get(o2);
                        int len = Array.getLength(a1);
                        if (len != Array.getLength(a2)) {
                            return false;
                        }
                        for (int j = 0; j < len; ++j) {
                            if (Array.get(a1, j).equals(Array.get(a2, j))) continue;
                            return false;
                        }
                        continue;
                    }
                    if (Runtime.equalsequals(f.get(o1), f.get(o2))) continue;
                    return false;
                }
                if ((c = c.getSuperclass()) != java.lang.Object.class && c != Object.class) continue;
                break;
            }
        }
        catch (IllegalAccessException iae) {
            throw new Error(iae);
        }
        return true;
    }

    public abstract void startIsolation_();

    public abstract int[] startIsolation_(Object[] var1);

    public abstract int[] startIsolation_(List var1);

    public abstract int startIsolation_(Object var1);

    public abstract int[] startIsolation_(Object var1, Object var2);

    public abstract void stopIsolation_();

    public abstract void stopIsolation_(int[] var1);

    public abstract void stopIsolation_(int var1);

    public static void startIsolation() {
        runtime.startIsolation_();
    }

    public static int[] startIsolation(Object[] objs) {
        return runtime.startIsolation_(objs);
    }

    public static int[] startIsolation(List objs) {
        return runtime.startIsolation_(objs);
    }

    public static int startIsolation(Object obj) {
        return runtime.startIsolation_(obj);
    }

    public static int[] startIsolation(Object obj1, Object obj2) {
        return runtime.startIsolation_(obj1, obj2);
    }

    public static void stopIsolation() {
        runtime.stopIsolation_();
    }

    public static void stopIsolation(int[] placeIDs) {
        runtime.stopIsolation_(placeIDs);
    }

    public static void stopIsolation(int placeID) {
        runtime.stopIsolation_(placeID);
    }

    static {
        exitCode = 0;
    }

    public static abstract class Factory {
        public abstract region.factory getRegionFactory();

        public abstract dist.factory getDistributionFactory();

        public abstract point.factory getPointFactory();

        public abstract clock.factory getClockFactory();

        public abstract accumulator.factory getAccumulatorFactory();

        public abstract place.factory getPlaceFactory();

        public abstract ArrayFactory getArrayFactory();
    }
}

