/*
 * Decompiled with CFR 0.152.
 */
package hj.lang;

import hj.array.Operator;
import hj.lang.IntReferenceArray;
import hj.lang.dist;
import hj.lang.hjArray;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;

public abstract class intArray
extends hjArray {
    public static final Operator.Binary sub = new Operator.Binary(){

        public int apply(int r, int s) {
            return r - s;
        }
    };
    public static final Operator.Binary add = new Operator.Binary(){

        public int apply(int r, int s) {
            return r + s;
        }
    };
    public static final Operator.Binary mul = new Operator.Binary(){

        public int apply(int r, int s) {
            return r * s;
        }
    };
    public static final Operator.Binary div = new Operator.Binary(){

        public int apply(int r, int s) {
            return r / s;
        }
    };
    public static final Operator.Binary max = new Operator.Binary(){

        public int apply(int r, int s) {
            return Math.max(r, s);
        }
    };
    public static final Operator.Unary abs = new Operator.Unary(){

        public int apply(int r) {
            return Math.abs(r);
        }
    };

    protected intArray(dist D, boolean mutable) {
        super(D, mutable);
    }

    public abstract int[] getBackingArray();

    public abstract int get(point var1);

    public abstract int getOrdinal(int var1);

    public abstract int get(int var1);

    public abstract int get(int var1, int var2);

    public abstract int get(int var1, int var2, int var3);

    public abstract int get(int var1, int var2, int var3, int var4);

    public int sum() {
        return this.reduce(add, 0);
    }

    public int max() {
        return this.reduce(max, 0);
    }

    public int max(Operator.Unary fun) {
        return this.lift(fun).reduce(max, 0);
    }

    public IntReferenceArray abs() {
        return this.lift(abs);
    }

    public int maxAbs() {
        return this.max(abs);
    }

    public IntReferenceArray add(intArray other) {
        return this.lift(add, other);
    }

    public IntReferenceArray mul(intArray other) {
        return this.lift(mul, other);
    }

    public IntReferenceArray sub(intArray other) {
        return this.lift(sub, other);
    }

    public IntReferenceArray div(intArray other) {
        return this.lift(div, other);
    }

    public IntReferenceArray scale(final int k) {
        return this.lift(new Operator.Unary(){

            public int apply(int r) {
                return r * k;
            }
        });
    }

    public abstract int reduce(Operator.Binary var1, int var2);

    public abstract int reduce(Operator.Binary var1, region var2);

    public abstract IntReferenceArray scan(Operator.Binary var1, int var2);

    public abstract IntReferenceArray restriction(region var1);

    public abstract IntReferenceArray restriction(dist var1);

    public IntReferenceArray restriction(place P) {
        return this.restriction(this.distribution.restriction(P));
    }

    public abstract IntReferenceArray union(intArray var1);

    public abstract IntReferenceArray overlay(intArray var1);

    public abstract void update(intArray var1);

    public abstract IntReferenceArray lift(Operator.Binary var1, intArray var2);

    public abstract IntReferenceArray lift(Operator.Unary var1);

    public abstract intArray toValueArray();

    public static class Constant
    extends Operator.Pointwise {
        private final int c_;

        public Constant(int c) {
            this.c_ = c;
        }

        public int apply(point p, int i) {
            return this.c_;
        }
    }

    public static interface pointwiseOp {
        public int apply(point var1);
    }
}

