/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.MultipleExceptions;
import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.activity;
import hj.runtime.wsh.AccumCell;
import hj.runtime.wsh.Accumulator;
import hj.runtime.wsh.Clock;
import hj.runtime.wsh.FinishState;
import hj.runtime.wsh.HjRunnable;
import hj.runtime.wsh.InvocationStrategy;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.SyncVar1;
import hj.runtime.wsh.SyncVar2;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.abstractmetrics.AbstractMetricsFactory;
import hj.runtime.wsh.clock.ClockManager;
import hj.runtime.wsh.clock.ClockManagerFactory;
import hj.runtime.wsh.clock.ClockRegMode;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
extends activity
implements HjRunnable,
AbstractMetrics {
    protected Place place_;
    protected FinishState finishState_ = null;
    protected Stack<FinishState> finishStack_ = null;
    public ClockManager activityClockManager;
    protected FinishState rootNode_;
    private AbstractMetrics abstractMetricsManager;
    private boolean notFinished = true;
    boolean success = true;
    private InvocationStrategy invocationStrategy = InvocationStrategy.ASYNC;
    private final String name;
    private final HashMap syncVarMap1 = new HashMap();
    private final HashMap syncVarMap2 = new HashMap();
    private SyncVar1 sv1 = null;
    private SyncVar2 sv2 = null;
    private Clock clk = null;
    private int cnt = 0;
    private final HashMap AccumCellMap = new HashMap();
    public int tmpForDelay;
    public int round;
    public Random rand = new Random();

    public Activity() {
        this(new Throwable().getStackTrace()[2].toString());
    }

    public Activity(String name) {
        this.name = name;
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.initializeActivity();
    }

    public Activity(List clockRegModes, String name) {
        this.name = name;
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.activityClockManager = ClockManagerFactory.getClockManager(this, clockRegModes);
        this.initializeActivity();
    }

    public Activity(List clockRegModes) {
        this(clockRegModes, new Throwable().getStackTrace()[2].toString());
    }

    public Activity(ClockRegMode clockRegMode, String name) {
        this.name = name;
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.activityClockManager = ClockManagerFactory.getClockManager(this, clockRegMode);
        this.initializeActivity();
    }

    public Activity(ClockRegMode clockRegMode) {
        this(clockRegMode, new Throwable().getStackTrace()[2].toString());
    }

    private void initializeActivity() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " Activity: initializing " + this);
        }
        if (this.activityClockManager != null) {
            this.activityClockManager.registerClocks();
        }
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.setResumeTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PoolRunner activityRunner = (PoolRunner)Thread.currentThread();
        if (Report.should_report("activity", 5)) {
            Report.report(5, activityRunner + " is running " + this);
        }
        activityRunner.setActivity(this);
        activityRunner.setPlace(this.getPlace());
        try {
            this.invocationStrategy.invokeHjTask(this);
        }
        catch (Throwable t) {
            this.success = false;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
        finally {
            this.setFinished();
        }
    }

    @Override
    public abstract void runHjTask();

    @Override
    public abstract boolean isHjTaskReady();

    public synchronized void join() throws InterruptedException {
        while (this.notFinished) {
            this.wait();
        }
    }

    private synchronized void setFinished() {
        this.notFinished = false;
        this.notifyAll();
    }

    public void setRootActivityFinishState(FinishState root) {
        this.rootNode_ = root;
    }

    public void setPlace(Place p) {
        this.place_ = p;
    }

    public Place getPlace() {
        return this.place_;
    }

    public void startFinish() {
        if (this.finishState_ != null) {
            this.getFinishStack().push(this.finishState_);
        }
        this.finishState_ = new FinishState(this);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " starts finish " + this.finishState_);
        }
    }

    public void stopFinish() {
        for (Clock c : this.finishState_.getClockList()) {
            c.drop(this);
        }
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " " + this + " enters stopfinish ");
        }
        this.finishState_.waitForFinish();
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " " + this + " continues stopfinish ");
        }
        FinishState state = this.finishState_;
        if (this.finishStack_ == null) {
            this.finishState_ = null;
        } else if (!this.finishStack_.isEmpty()) {
            this.finishState_ = this.finishStack_.pop();
        }
        Stack result = state.exceptions();
        if (result != null && !result.empty()) {
            if (result.size() == 1) {
                Throwable t = (Throwable)result.pop();
                if (Report.should_report("activity", 3)) {
                    Report.report(3, PoolRunner.logString() + " " + this + " throws  " + t);
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new MultipleExceptions(result);
        }
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " exits from finish.");
        }
    }

    private Stack<FinishState> getFinishStack() {
        if (this.finishStack_ == null) {
            this.finishStack_ = new Stack();
        }
        return this.finishStack_;
    }

    private boolean inFinish() {
        return this.finishState_ != null;
    }

    public void pushException(Throwable t) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " pushing exception " + t + " onto " + this.finishState_);
        }
        this.finishState_.pushException(t);
    }

    public List<Clock> getIEFclockList() {
        if (this.finishState_ != null) {
            return this.finishState_.getClockList();
        }
        return null;
    }

    public void addClock(ClockRegMode cr) {
        if (this.activityClockManager != null) {
            this.activityClockManager.addClock(cr);
        } else {
            this.activityClockManager = ClockManagerFactory.getClockManager(this, cr);
        }
    }

    public void dropClock(Clock c) {
        if (this.activityClockManager != null) {
            this.activityClockManager.dropClock(c);
            if (this.activityClockManager.getNbRegisteredClocks() == 0) {
                this.activityClockManager = null;
            }
        } else if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " dropClock attempt failed because no clocks are registered in this activity " + c + ".");
        }
    }

    protected void dropAllClocks() {
        if (this.activityClockManager != null) {
            this.activityClockManager.dropAllClocks();
            this.activityClockManager = null;
        } else if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " dropAllClock attempt failed because no clocks are registered in this activity ");
        }
    }

    public void doNext() {
        if (this.activityClockManager != null) {
            this.activityClockManager.doNext();
        } else if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " doNext attempt failed because no clocks are registered in this activity ");
        }
    }

    public void doSignal() {
        if (this.activityClockManager != null) {
            this.activityClockManager.doSignal();
        } else if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " signal attempt failed because no clocks are registered in this activity ");
        }
    }

    public void doWait() {
        if (this.activityClockManager != null) {
            this.activityClockManager.doWait();
        } else if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " doWait attempt failed because no clocks are registered in this activity ");
        }
    }

    public int doNext1(String loc) {
        int ret = 0;
        if (this.activityClockManager != null) {
            ret = this.activityClockManager.doNext1(loc);
        } else {
            if (Report.should_report("clock", 3)) {
                Report.report(3, PoolRunner.logString() + " doNext1 attempt failed because no clocks are registered in this activity ");
            }
            assert (false);
        }
        return ret;
    }

    public void doNext2() {
        if (this.activityClockManager != null) {
            this.activityClockManager.doNext2();
        } else {
            if (Report.should_report("clock", 3)) {
                Report.report(3, PoolRunner.logString() + " doNext2 attempt failed because no clocks are registered in this activity ");
            }
            assert (false);
        }
    }

    public void putSyncVar1(Clock c, SyncVar1 s1) {
        if (this.cnt > 1) {
            this.syncVarMap1.put(c, s1);
        } else if (this.cnt == 1) {
            if (c == this.clk) {
                this.sv1 = s1;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.clk, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.clk, this.sv2);
                }
                this.syncVarMap1.put(c, s1);
                this.cnt = 2;
            }
        } else {
            this.clk = c;
            this.sv1 = s1;
            this.cnt = 1;
        }
    }

    public void putSyncVar2(Clock c, SyncVar2 s2) {
        if (this.cnt > 1) {
            this.syncVarMap2.put(c, s2);
        } else if (this.cnt == 1) {
            if (c == this.clk) {
                this.sv2 = s2;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.clk, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.clk, this.sv2);
                }
                this.syncVarMap2.put(c, s2);
                this.cnt = 2;
            }
        } else {
            this.clk = c;
            this.sv2 = s2;
            this.cnt = 1;
        }
    }

    public SyncVar1 getSyncVar1(Clock c) {
        if (this.cnt == 1 && c == this.clk) {
            return this.sv1;
        }
        if (this.cnt > 1) {
            return (SyncVar1)this.syncVarMap1.get(c);
        }
        return null;
    }

    public SyncVar2 getSyncVar2(Clock c) {
        if (this.cnt == 1 && c == this.clk) {
            return this.sv2;
        }
        if (this.cnt > 1) {
            return (SyncVar2)this.syncVarMap2.get(c);
        }
        return null;
    }

    public ClockRegMode checkClockUse(ClockRegMode crm) {
        Clock c = (Clock)crm.getClock();
        if (c.dropped()) {
            throw new PhaserException("Cannot transmit dropped phaser.");
        }
        if (c.quiescent()) {
            throw new PhaserException("Cannot transmit sent (resumed) phaser.");
        }
        if (this.inFinish() && !this.finishState_.getClockList().contains(c)) {
            throw new PhaserException("IEF scope rule violation: The innermost finish doesn't include this phaser.");
        }
        return crm;
    }

    public int getNbRegisteredClocks() {
        if (this.activityClockManager == null) {
            return 0;
        }
        return this.activityClockManager.getNbRegisteredClocks();
    }

    public void registerClocks() {
        if (this.activityClockManager != null) {
            this.activityClockManager.registerClocks();
        }
    }

    public void putAccumCell(Accumulator acc, Object elem) {
        this.AccumCellMap.put(acc, elem);
    }

    public AccumCell getAccumCell(Accumulator acc) {
        return (AccumCell)this.AccumCellMap.get(acc);
    }

    @Override
    public long getTotalOps() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalOps();
        }
        return 0L;
    }

    @Override
    public long getCritPathOps() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathOps();
        }
        return 0L;
    }

    @Override
    public void addLocalOps(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addLocalOps(n);
        }
    }

    @Override
    public void addCritPathOps(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addCritPathOps(n);
        }
    }

    @Override
    public void maxCritPathOps(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathOps(n);
        }
    }

    @Override
    public long getTotalUnblockedTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalUnblockedTime();
        }
        return 0L;
    }

    @Override
    public long getCritPathTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathTime();
        }
        return 0L;
    }

    @Override
    public void maxCritPathTime(long t) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathTime(t);
        }
    }

    @Override
    public long getResumeTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getResumeTime();
        }
        return 0L;
    }

    @Override
    public void setResumeTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.setResumeTime();
        }
    }

    @Override
    public void updateIdealTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.updateIdealTime();
        }
    }

    @Override
    public long getCurrentTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCurrentTime();
        }
        return 0L;
    }

    @Override
    public void addUnblockedTime(long t) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addUnblockedTime(t);
        }
    }

    public Activity finalizeActivitySpawn(Activity child) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " spawns " + child);
        }
        FinishState target = this.finishState_ == null ? this.rootNode_ : this.finishState_;
        child.setRootActivityFinishState(target);
        target.notifySubActivitySpawn();
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            child.maxCritPathOps(this.getCritPathOps());
        }
        return child;
    }

    public void finalizeTermination() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " " + this + "terminates.");
        }
        this.finalizeTerminationCleanup();
        if (this.rootNode_ != null) {
            this.rootNode_.notifySubActivityTermination();
        }
    }

    public void finalizeTermination(Throwable t) {
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " terminates abruptly with " + t);
        }
        this.finalizeTerminationCleanup();
        if (this.rootNode_ != null) {
            this.rootNode_.notifySubActivityTermination(t);
        }
    }

    public void finalizeTerminationCleanup() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            Runtime.here().maxCritPathOps(this.getCritPathOps());
            Runtime.here().addLocalOps(this.getTotalOps());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.updateIdealTime();
                Runtime.here().addUnblockedTime(this.getTotalUnblockedTime());
                Runtime.here().maxCritPathTime(this.getCritPathTime());
            }
        }
        this.dropAllClocks();
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " drops clocks, has rootNode_ " + this.rootNode_);
        }
    }

    public String myName() {
        return this.name != null ? this.name : "Activity " + Long.toHexString(System.identityHashCode(this));
    }

    public String toString() {
        String rv = "<" + this.myName();
        rv = rv + " " + this.finishState_ + "," + this.rootNode_;
        rv = rv + ">";
        return rv;
    }

    public String shortString() {
        return "<" + this.myName() + ">";
    }

    public void setInvocationStrategy(InvocationStrategy async_in_finish) {
        this.invocationStrategy = async_in_finish;
    }
}

